/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter.internal;

import org.eclipse.dltk.formatter.IFormatterIndentGenerator;

public class FormatterMixedIndentGenerator
implements IFormatterIndentGenerator {
    private final int indentSize;
    private final int tabSize;

    public FormatterMixedIndentGenerator(int indentSize, int tabSize) {
        this.indentSize = Math.max(indentSize, 1);
        this.tabSize = Math.max(tabSize, 1);
    }

    @Override
    public void generateIndent(int indentLevel, StringBuilder target) {
        int indent = indentLevel * this.indentSize;
        int tabCount = indent / this.tabSize;
        int i = 0;
        while (i < tabCount) {
            target.append('\t');
            ++i;
        }
        int spaceCount = indent % this.tabSize;
        int i2 = 0;
        while (i2 < spaceCount) {
            target.append(' ');
            ++i2;
        }
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }
}

