/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinAlias;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;

public class AliasedRubyMixinMethod
extends RubyMixinMethod {
    private final RubyMixinAlias alias;

    public AliasedRubyMixinMethod(RubyMixinModel model, RubyMixinAlias alias) {
        super(model, alias.getKey());
        this.alias = alias;
        RubyAliasExpression node = alias.getAlias();
        int length = node.sourceEnd() - node.sourceStart();
        IMethod sourceMethod = AliasedRubyMixinMethod.findSourceMethod(model, alias);
        ModelElement fakeMethodParent = sourceMethod != null && sourceMethod.getParent() instanceof ModelElement ? (ModelElement)sourceMethod.getParent() : (ModelElement)alias.getSourceModule();
        FakeMethod fakeMethod = new FakeMethod(fakeMethodParent, node.getNewValue(), node.sourceStart(), length, node.sourceStart(), length);
        if (sourceMethod != null) {
            try {
                fakeMethod.setFlags(sourceMethod.getFlags());
                fakeMethod.setParameters(sourceMethod.getParameters());
            }
            catch (ModelException modelException) {}
        }
        this.setSourceMethods(new IMethod[]{fakeMethod});
    }

    private static IMethod findSourceMethod(RubyMixinModel model, RubyMixinAlias alias) {
        IMethod[] sourceMethods = RubyMixinMethod.getSourceMethods(model, alias.getOldKey());
        if (sourceMethods.length == 1 && sourceMethods[0] != null) {
            return sourceMethods[0];
        }
        return null;
    }

    public String getName() {
        return this.alias.getNewName();
    }

    public RubyMixinVariable[] getVariables() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.alias.getOldKey());
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinVariable) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new RubyMixinVariable[result.size()]);
    }
}

