/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.util.TableLayoutComposite;
import org.eclipse.dltk.javascript.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ParameterEditDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ChangeParametersControl
extends Composite {
    private static final String[] PROPERTIES = new String[]{"new", "default"};
    private static final int NEWNAME_PROP = 0;
    private static final int DEFAULT_PROP = 1;
    private static final int ROW_COUNT = 7;
    private final Mode fMode;
    private final IParameterListChangeListener fListener;
    private List<ParameterInfo> fParameterInfos;
    private TableViewer fTableViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fEditButton;
    private Button fAddButton;
    private Button fRemoveButton;

    public ChangeParametersControl(Composite parent, int style, String label, IParameterListChangeListener listener, Mode mode) {
        super(parent, style);
        Assert.isNotNull((Object)listener);
        this.fListener = listener;
        this.fMode = mode;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        if (label != null) {
            Label tableLabel = new Label((Composite)this, 0);
            GridData labelGd = new GridData();
            labelGd.horizontalSpan = 2;
            tableLabel.setLayoutData((Object)labelGd);
            tableLabel.setText(label);
        }
        this.createParameterList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List<ParameterInfo> parameterInfos) {
        Assert.isNotNull(parameterInfos);
        this.fParameterInfos = parameterInfos;
        this.fTableViewer.setInput(this.fParameterInfos);
        if (this.fParameterInfos.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fParameterInfos.get(0)));
        }
    }

    public void editParameter(ParameterInfo info) {
        this.fTableViewer.getControl().setFocus();
        if (!info.isDeleted()) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)info), true);
            this.updateButtonsEnabledState();
            this.editColumnOrNextPossible(0);
            return;
        }
    }

    private void createParameterList(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layouter);
        Table table = new Table((Composite)layouter, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setResizable(true);
        tc.setText(RefactoringMessages.ChangeParametersControl_table_name);
        if (this.fMode.canChangeDefault()) {
            tc = new TableColumn(table, 0, 1);
            tc.setResizable(true);
            tc.setText(RefactoringMessages.ChangeParametersControl_table_defaultValue);
        }
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)7);
        gd.widthHint = 40;
        layouter.setLayoutData((Object)gd);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ParameterInfoContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ParameterInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && e.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    e.detail = 0;
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    e.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private void editColumnOrNextPossible(int column) {
        ParameterInfo[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int nextColumn = column;
        do {
            this.fTableViewer.editElement((Object)selected[0], nextColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((nextColumn = this.nextColumn(nextColumn)) != column);
    }

    private void editColumnOrPrevPossible(int column) {
        ParameterInfo[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int prevColumn = column;
        do {
            this.fTableViewer.editElement((Object)selected[0], prevColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((prevColumn = this.prevColumn(prevColumn)) != column);
    }

    private int nextColumn(int column) {
        return column >= this.getTable().getColumnCount() - 1 ? 0 : column + 1;
    }

    private int prevColumn(int column) {
        return column <= 0 ? this.getTable().getColumnCount() - 1 : column - 1;
    }

    private void addColumnLayoutData(TableLayoutComposite layouter) {
        if (this.fMode.canChangeDefault()) {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(33, true));
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(34, true));
        } else {
            layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }
    }

    private ParameterInfo[] getSelectedElements() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection == null) {
            return new ParameterInfo[0];
        }
        if (!(selection instanceof IStructuredSelection)) {
            return new ParameterInfo[0];
        }
        List selected = ((IStructuredSelection)selection).toList();
        return selected.toArray(new ParameterInfo[selected.size()]);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        if (this.fMode.canAddParameters()) {
            this.fAddButton = this.createAddButton(buttonComposite);
        }
        this.fEditButton = this.createEditButton(buttonComposite);
        if (this.fMode.canAddParameters()) {
            this.fRemoveButton = this.createRemoveButton(buttonComposite);
        }
        if (buttonComposite.getChildren().length != 0) {
            this.addSpacer(buttonComposite);
        }
        this.fUpButton = this.createButton(buttonComposite, RefactoringMessages.ChangeParametersControl_buttons_move_up, true);
        this.fDownButton = this.createButton(buttonComposite, RefactoringMessages.ChangeParametersControl_buttons_move_down, false);
        this.updateButtonsEnabledState();
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 5;
        label.setLayoutData((Object)gd);
    }

    private void updateButtonsEnabledState() {
        this.fUpButton.setEnabled(this.canMove(true));
        this.fDownButton.setEnabled(this.canMove(false));
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.getTableSelectionCount() == 1);
        }
        if (this.fAddButton != null) {
            this.fAddButton.setEnabled(true);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createEditButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_edit);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ParameterInfo[] selected = ChangeParametersControl.this.getSelectedElements();
                    Assert.isTrue((selected.length == 1 ? 1 : 0) != 0);
                    ParameterInfo parameterInfo = selected[0];
                    ParameterEditDialog dialog = new ParameterEditDialog(ChangeParametersControl.this.getShell(), parameterInfo, ChangeParametersControl.this.fMode.canChangeTypes(), ChangeParametersControl.this.fMode.canChangeDefault());
                    dialog.open();
                    ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                    ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, PROPERTIES);
                }
                finally {
                    ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                }
            }
        });
        return button;
    }

    private Button createAddButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_add);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] excludedParamNames = new String[ChangeParametersControl.this.fParameterInfos.size()];
                int i = 0;
                while (i < ChangeParametersControl.this.fParameterInfos.size()) {
                    ParameterInfo info = (ParameterInfo)ChangeParametersControl.this.fParameterInfos.get(i);
                    excludedParamNames[i] = info.getNewName();
                    ++i;
                }
                ParameterInfo newInfo = ParameterInfo.createInfoForAddedParameter((String)"", (String)"", (String)"undefined");
                int insertIndex = ChangeParametersControl.this.fParameterInfos.size();
                int i2 = ChangeParametersControl.this.fParameterInfos.size() - 1;
                while (i2 >= 0) {
                    ParameterInfo cfr_ignored_0 = (ParameterInfo)ChangeParametersControl.this.fParameterInfos.get(i2);
                    --i2;
                }
                ChangeParametersControl.this.fParameterInfos.add(insertIndex, newInfo);
                ChangeParametersControl.this.fListener.parameterAdded(newInfo);
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                ChangeParametersControl.this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newInfo), true);
                ChangeParametersControl.this.updateButtonsEnabledState();
                ChangeParametersControl.this.editColumnOrNextPossible(0);
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite buttonComposite) {
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_remove);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeParametersControl.this.getTable().getSelectionIndices()[0];
                ParameterInfo[] selected = ChangeParametersControl.this.getSelectedElements();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i].isAdded()) {
                        ChangeParametersControl.this.fParameterInfos.remove(selected[i]);
                    } else {
                        selected[i].markAsDeleted();
                    }
                    ++i;
                }
                this.restoreSelection(index);
            }

            private void restoreSelection(int index) {
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                int itemCount = ChangeParametersControl.this.getTableItemCount();
                if (itemCount != 0) {
                    if (index >= itemCount) {
                        index = itemCount - 1;
                    }
                    ChangeParametersControl.this.getTable().setSelection(index);
                }
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private Button createButton(Composite buttonComposite, String text, final boolean up) {
        Button button = new Button(buttonComposite, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection savedSelection = ChangeParametersControl.this.fTableViewer.getSelection();
                if (savedSelection == null) {
                    return;
                }
                ParameterInfo[] selection = ChangeParametersControl.this.getSelectedElements();
                if (selection.length == 0) {
                    return;
                }
                if (up) {
                    ChangeParametersControl.this.moveUp(selection);
                } else {
                    ChangeParametersControl.this.moveDown(selection);
                }
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.setSelection(savedSelection);
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
            }
        });
        return button;
    }

    private void addCellEditors() {
        this.fTableViewer.setColumnProperties(PROPERTIES);
        TableTextCellEditor[] editors = new TableTextCellEditor[PROPERTIES.length];
        editors[0] = new TableTextCellEditor(this.fTableViewer, 0);
        editors[1] = new TableTextCellEditor(this.fTableViewer, 1);
        int i = 0;
        while (i < editors.length) {
            final int editorColumn = i;
            TableTextCellEditor editor = editors[i];
            editor.getText().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 16: {
                            ChangeParametersControl.this.editColumnOrNextPossible(ChangeParametersControl.this.nextColumn(editorColumn));
                            e.detail = 0;
                            break;
                        }
                        case 8: {
                            ChangeParametersControl.this.editColumnOrPrevPossible(ChangeParametersControl.this.prevColumn(editorColumn));
                            e.detail = 0;
                            break;
                        }
                    }
                }
            });
            TextFieldNavigationHandler.install((Text)editor.getText());
            ++i;
        }
        this.fTableViewer.setCellEditors((CellEditor[])editors);
        this.fTableViewer.setCellModifier((ICellModifier)new ParametersCellModifier());
    }

    private void moveUp(ParameterInfo[] selection) {
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(selection));
    }

    private void moveDown(ParameterInfo[] selection) {
        Collections.reverse(this.fParameterInfos);
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(selection));
        Collections.reverse(this.fParameterInfos);
    }

    private static void moveUp(List<ParameterInfo> elements, List<ParameterInfo> move) {
        ArrayList<Object> res = new ArrayList<Object>(elements.size());
        ArrayList<ParameterInfo> deleted = new ArrayList<ParameterInfo>();
        ParameterInfo floating = null;
        for (ParameterInfo parameterInfo : elements) {
            if (move.contains(parameterInfo)) {
                res.add(parameterInfo);
                continue;
            }
            if (parameterInfo.isDeleted()) {
                deleted.add(parameterInfo);
                continue;
            }
            if (floating != null) {
                res.add(floating);
            }
            floating = parameterInfo;
        }
        if (floating != null) {
            res.add(floating);
        }
        res.addAll(deleted);
        elements.clear();
        for (ParameterInfo parameterInfo : res) {
            elements.add(parameterInfo);
        }
    }

    private boolean canMove(boolean up) {
        int notDeletedInfosCount = this.getNotDeletedInfosCount();
        if (notDeletedInfosCount == 0) {
            return false;
        }
        int[] indc = this.getTable().getSelectionIndices();
        if (indc.length == 0) {
            return false;
        }
        int invalid = up ? 0 : notDeletedInfosCount - 1;
        int i = 0;
        while (i < indc.length) {
            if (indc[i] == invalid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getNotDeletedInfosCount() {
        if (this.fParameterInfos == null) {
            return 0;
        }
        int result = 0;
        for (ParameterInfo info : this.fParameterInfos) {
            if (info.isDeleted()) continue;
            ++result;
        }
        return result;
    }

    public static enum Mode {
        EXTRACT_METHOD,
        CHANGE_METHOD_SIGNATURE,
        INTRODUCE_PARAMETER;


        public boolean canChangeTypes() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canAddParameters() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canChangeDefault() {
            return this == CHANGE_METHOD_SIGNATURE;
        }
    }

    private static class ParameterInfoContentProvider
    implements IStructuredContentProvider {
        private ParameterInfoContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.removeMarkedAsDeleted((List)inputElement);
        }

        private ParameterInfo[] removeMarkedAsDeleted(List<ParameterInfo> paramInfos) {
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(paramInfos.size());
            for (ParameterInfo info : paramInfos) {
                if (info.isDeleted()) continue;
                result.add(info);
            }
            return result.toArray(new ParameterInfo[result.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ParameterInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private ParameterInfoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ParameterInfo info = (ParameterInfo)element;
            switch (columnIndex) {
                case 0: {
                    return info.getNewName();
                }
                case 1: {
                    if (info.isAdded()) {
                        return info.getDefaultValue();
                    }
                    return "-";
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex) + ": " + element);
        }

        public Font getFont(Object element, int columnIndex) {
            ParameterInfo info = (ParameterInfo)element;
            if (info.isAdded()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private class ParametersCellModifier
    implements ICellModifier {
        private ParametersCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            Assert.isTrue((boolean)(element instanceof ParameterInfo));
            if (property.equals(PROPERTIES[0])) {
                return true;
            }
            if (property.equals(PROPERTIES[1])) {
                return ((ParameterInfo)element).isAdded();
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        public Object getValue(Object element, String property) {
            Assert.isTrue((boolean)(element instanceof ParameterInfo));
            if (property.equals(PROPERTIES[0])) {
                return ((ParameterInfo)element).getNewName();
            }
            if (property.equals(PROPERTIES[1])) {
                return ((ParameterInfo)element).getDefaultValue();
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public void modify(Object element, String property, Object value) {
            boolean unchanged;
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            if (!(element instanceof ParameterInfo)) {
                return;
            }
            ParameterInfo parameterInfo = (ParameterInfo)element;
            if (property.equals(PROPERTIES[0])) {
                unchanged = parameterInfo.getNewName().equals(value);
                parameterInfo.setNewName((String)value);
            } else if (property.equals(PROPERTIES[1])) {
                unchanged = parameterInfo.getDefaultValue().equals(value);
                parameterInfo.setDefaultValue((String)value);
            } else {
                throw new IllegalStateException();
            }
            if (!unchanged) {
                ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, new String[]{property});
            }
        }
    }
}

