/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.compare;

import java.util.Stack;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class ScriptMergeViewer
extends TextMergeViewer {
    private static final Stack<IDLTKUILanguageToolkit> toolkitStorage = new Stack();
    private final IDLTKUILanguageToolkit fToolkit;

    private static int pushToolkit(IDLTKUILanguageToolkit toolkit) {
        Assert.isNotNull((Object)toolkit);
        toolkitStorage.push(toolkit);
        return 0x2000000;
    }

    private static void popToolkit() {
        toolkitStorage.pop();
    }

    public ScriptMergeViewer(Composite parent, CompareConfiguration configuration, IDLTKUILanguageToolkit toolkit) {
        super(parent, ScriptMergeViewer.pushToolkit(toolkit), configuration);
        ScriptMergeViewer.popToolkit();
        this.fToolkit = toolkit;
    }

    public ScriptMergeViewer(Composite parent, CompareConfiguration configuration, String natureId) {
        this(parent, configuration, DLTKUILanguageManager.getLanguageToolkit(natureId));
    }

    protected IDLTKUILanguageToolkit getToolkit() {
        return this.fToolkit != null ? this.fToolkit : toolkitStorage.peek();
    }

    protected ScriptTextTools getTextTools() {
        return this.getToolkit().getTextTools();
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.getToolkit().getPreferenceStore();
    }

    public String getTitle() {
        return NLS.bind((String)"{0} Compare", (Object)this.getToolkit().getCoreToolkit().getLanguageName());
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (!(textViewer instanceof SourceViewer)) {
            return;
        }
        ScriptTextTools tools = this.getTextTools();
        if (tools == null) {
            return;
        }
        SourceViewer sourceViewer = (SourceViewer)textViewer;
        sourceViewer.configure((SourceViewerConfiguration)tools.createSourceViewerConfiguraton(this.getPreferenceStore(), null));
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        ScriptTextTools tools = this.getTextTools();
        return tools != null ? tools.createDocumentPartitioner() : null;
    }

    protected String getDocumentPartitioning() {
        ScriptTextTools tools = this.getTextTools();
        return tools != null ? tools.getDefaultPartitioning() : null;
    }
}

