/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.selection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.linuxtools.man.parser.ManPage;

public class ShellDocumentationProvider
implements IScriptDocumentationProvider {
    public Reader getInfo(String content) {
        String helpInfo = ShellDocumentationProvider.getHelp(content);
        if (!helpInfo.isEmpty()) {
            return new StringReader("<pre>" + helpInfo + "</pre>");
        }
        StringBuilder manInfo = new ManPage(content).getStrippedPage();
        if (manInfo.length() == 0) {
            return null;
        }
        int maxLen = 10240;
        StringBuilder sb = new StringBuilder("<pre>");
        if (manInfo.length() > 10240) {
            sb.append(manInfo.substring(0, 10240));
        } else {
            sb.append((CharSequence)manInfo);
        }
        sb.append("</pre>");
        if (manInfo.length() > 10240) {
            sb.append("<p>This man page is truncated, use <b>Show Man Page</b> (Alt+M) to see the whole page for the selected word.</p>");
        }
        return new StringReader(sb.toString());
    }

    private static String getHelp(String command) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("bash");
        commands.add("-c");
        commands.add("help " + command);
        ProcessBuilder process = new ProcessBuilder(commands);
        StringBuilder out = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream stream = process.start().getInputStream();){
                char[] buffer = new char[1024];
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (InputStreamReader in = new InputStreamReader(stream);){
                    int rsz;
                    while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                        out.append(buffer, 0, rsz);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        return null;
    }
}

