/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring.code;

import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.dltk.javascript.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InlineMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "InlineMethodInputPage";
    private static final String DESCRIPTION = RefactoringMessages.InlineMethodInputPage_description;
    private InlineMethodRefactoring fRefactoring;
    private Button fRemove;

    public InlineMethodInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(DLTKPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fRefactoring = (InlineMethodRefactoring)this.getRefactoring();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        GridData gd = null;
        boolean all = this.fRefactoring.getInitialMode() == InlineMethodRefactoring.Mode.ALL;
        Label label = new Label(result, 0);
        String methodLabel = this.fRefactoring.getMethod().getElementName();
        label.setText(Messages.format((String)RefactoringMessages.InlineMethodInputPage_inline_method, (Object)methodLabel));
        label.setLayoutData((Object)new GridData(768));
        Composite separator = new Composite(result, 0);
        separator.setLayoutData((Object)new GridData(0, 0));
        Button radioAll = new Button(result, 16);
        radioAll.setLayoutData((Object)new GridData(768));
        radioAll.setText(RefactoringMessages.InlineMethodInputPage_all_invocations);
        radioAll.setSelection(all);
        radioAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InlineMethodInputPage.this.fRemove.setEnabled(InlineMethodInputPage.this.fRefactoring.canEnableDeleteSource());
                if (((Button)event.widget).getSelection()) {
                    InlineMethodInputPage.this.changeRefactoring(InlineMethodRefactoring.Mode.ALL);
                }
            }
        });
        this.fRemove = new Button(result, 32);
        gd = new GridData(768);
        gd.horizontalIndent = this.convertWidthInCharsToPixels(3);
        this.fRemove.setLayoutData((Object)gd);
        this.fRemove.setText(RefactoringMessages.InlineMethodInputPage_delete_declaration);
        this.fRemove.setEnabled(all && this.fRefactoring.canEnableDeleteSource());
        this.fRemove.setSelection(this.fRefactoring.canEnableDeleteSource());
        this.fRefactoring.setDeleteSource(this.fRefactoring.canEnableDeleteSource());
        this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InlineMethodInputPage.this.fRefactoring.setDeleteSource(((Button)e.widget).getSelection());
            }
        });
        Button radioSelected = new Button(result, 16);
        radioSelected.setLayoutData((Object)new GridData(768));
        radioSelected.setText(RefactoringMessages.InlineMethodInputPage_only_selected);
        radioSelected.setSelection(!all);
        if (all) {
            radioSelected.setEnabled(false);
            radioAll.setFocus();
        } else {
            radioSelected.setFocus();
        }
        radioSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InlineMethodInputPage.this.fRemove.setEnabled(false);
                if (((Button)event.widget).getSelection()) {
                    InlineMethodInputPage.this.changeRefactoring(InlineMethodRefactoring.Mode.SINGLE);
                }
            }
        });
        Dialog.applyDialogFont((Control)result);
    }

    private void changeRefactoring(InlineMethodRefactoring.Mode mode) {
        RefactoringStatus status = this.fRefactoring.setCurrentMode(mode);
        this.setPageComplete(status);
    }
}

