/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.SpecificContentAssistExecutor;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.completion.CompletionProposalCategory;
import org.eclipse.dltk.ui.text.completion.CompletionProposalComputerRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

final class SpecificContentAssistAction
extends Action
implements IUpdate {
    private final CompletionProposalCategory fCategory;
    private final SpecificContentAssistExecutor fExecutor = new SpecificContentAssistExecutor(CompletionProposalComputerRegistry.getDefault());
    private ScriptEditor fEditor;

    public SpecificContentAssistAction(CompletionProposalCategory category) {
        this.fCategory = category;
        this.setText(category.getName());
        this.setImageDescriptor(category.getImageDescriptor());
        this.setActionDefinitionId("org.eclipse.dltk.ui.specific_content_assist.command");
    }

    public void run() {
        ITextEditor editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        this.fExecutor.invokeContentAssist(editor, this.fCategory.getId());
    }

    private ITextEditor getActiveEditor() {
        return this.fEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        ScriptEditor editor = part instanceof ScriptEditor ? (ScriptEditor)part : null;
        this.fEditor = editor;
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }

    private boolean computeEnablement(ITextEditor editor) {
        boolean hasContentAssist;
        if (editor == null) {
            return false;
        }
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        boolean bl = hasContentAssist = target != null && target.canDoOperation(13);
        if (!hasContentAssist) {
            return false;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        return this.isValidSelection(selection);
    }

    private boolean isValidSelection(ISelection selection) {
        String contentType;
        IDLTKUILanguageToolkit toolkit;
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        String partitioning = null;
        ISourceModule modelElement = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
        if (modelElement != null && (toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)modelElement)) != null) {
            partitioning = toolkit.getPartitioningId();
        }
        if (partitioning != null) {
            try {
                contentType = TextUtilities.getContentType((IDocument)document, (String)partitioning, (int)offset, (boolean)true);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        } else {
            contentType = "__dftl_partition_content_type";
        }
        return this.fCategory.hasComputers(contentType);
    }

    private IDocument getDocument() {
        Assert.isTrue((this.fEditor != null ? 1 : 0) != 0);
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IDocument document = provider.getDocument((Object)this.fEditor.getEditorInput());
        return document;
    }

    public void update() {
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }
}

