/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Cache {
    private static final ILock containerLock = Job.getJobManager().newLock();
    private static final Map<Integer, Container> containerById = new HashMap<Integer, Container>();
    private static final ILock fileLock = Job.getJobManager().newLock();
    private static final Map<Integer, Map<Integer, File>> filesByContainer = new HashMap<Integer, Map<Integer, File>>();

    public static void addContainer(Container container) {
        containerLock.acquire();
        try {
            int containerId = container.getId();
            containerById.put(containerId, container);
        }
        finally {
            containerLock.release();
        }
    }

    public static void addFile(File file) {
        fileLock.acquire();
        try {
            int containerId = file.getContainerId();
            Map<Integer, File> files = filesByContainer.get(containerId);
            if (files == null) {
                files = new HashMap<Integer, File>();
                filesByContainer.put(containerId, files);
            }
            files.put(file.getId(), file);
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteContainerById(int id) {
        containerLock.acquire();
        try {
            containerById.remove(id);
            H2Cache.deleteFilesByContainerId(id);
        }
        finally {
            containerLock.release();
        }
    }

    public static void deleteContainerByPath(String path) {
        containerLock.acquire();
        try {
            Container container = H2Cache.selectContainerByPath(path);
            if (container != null) {
                H2Cache.deleteContainerById(container.getId());
            }
        }
        finally {
            containerLock.release();
        }
    }

    public static void deleteFileByContainerIdAndPath(int containerId, String path) {
        fileLock.acquire();
        try {
            File file = H2Cache.selectFileByContainerIdAndPath(containerId, path);
            if (file != null) {
                H2Cache.deleteFileById(file.getId());
            }
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteFileById(int id) {
        fileLock.acquire();
        try {
            Iterator<Map<Integer, File>> i = filesByContainer.values().iterator();
            while (i.hasNext()) {
                i.next().remove(id);
            }
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteFilesByContainerId(int id) {
        fileLock.acquire();
        try {
            filesByContainer.remove(id);
        }
        finally {
            fileLock.release();
        }
    }

    public static Container selectContainerById(int id) {
        containerLock.acquire();
        try {
            Container container = containerById.get(id);
            return container;
        }
        finally {
            containerLock.release();
        }
    }

    public static Container selectContainerByPath(String path) {
        containerLock.acquire();
        try {
            for (Container container : containerById.values()) {
                if (!container.getPath().equals(path)) continue;
                Container container2 = container;
                return container2;
            }
            return null;
        }
        finally {
            containerLock.release();
        }
    }

    public static File selectFileByContainerIdAndPath(int containerId, String path) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.get(containerId);
            if (files != null) {
                for (File file : files.values()) {
                    if (!file.getPath().equals(path)) continue;
                    File file2 = file;
                    return file2;
                }
            }
        }
        finally {
            fileLock.release();
        }
        return null;
    }

    public static File selectFileById(int id) {
        fileLock.acquire();
        try {
            Iterator<Map<Integer, File>> i = filesByContainer.values().iterator();
            while (i.hasNext()) {
                File file = i.next().get(id);
                if (file == null) continue;
                File file2 = file;
                return file2;
            }
            return null;
        }
        finally {
            fileLock.release();
        }
    }

    public static Collection<File> selectFilesByContainerId(int id) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.get(id);
            if (files != null) {
                Collection<File> collection = files.values();
                return collection;
            }
            List<File> list = Collections.emptyList();
            return list;
        }
        finally {
            fileLock.release();
        }
    }

    public static File[] selectFilesByContainerIdAsArray(int id) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.get(id);
            if (files != null) {
                File[] fileArray = files.values().toArray(new File[files.values().size()]);
                return fileArray;
            }
            return null;
        }
        finally {
            fileLock.release();
        }
    }
}

