/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.SearcherManager;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.core.search.indexing.IIndexThreadListener;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index.lucene.IndexContainer;
import org.eclipse.dltk.internal.core.index.lucene.IndexProperties;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.Utils;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;
import org.osgi.framework.Bundle;

public enum LuceneManager {
    INSTANCE;

    private static final String INDEX_DIR = "index";
    private static final String PROPERTIES_FILE = ".properties";
    private static final String MAPPINGS_FILE = ".mappings";
    private final String fIndexRoot;
    private final Properties fIndexProperties = new Properties();
    private final Properties fContainerMappings = new Properties();
    private final Map<String, IndexContainer> fIndexContainers = new ConcurrentHashMap<String, IndexContainer>();
    private final Committer fCommitter = new Committer();

    private LuceneManager() {
        this.fIndexRoot = Platform.getStateLocation((Bundle)LucenePlugin.getDefault().getBundle()).append(INDEX_DIR).toOSString();
        File indexRootDirectory = new File(this.fIndexRoot);
        if (!indexRootDirectory.exists()) {
            indexRootDirectory.mkdirs();
        }
        this.startup();
    }

    public final IndexWriter findIndexWriter(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexWriter(dataType, elementType);
    }

    public final SearcherManager findIndexSearcher(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexSearcher(dataType, elementType);
    }

    public final IndexWriter findTimestampsWriter(String container) {
        return this.getIndexContainer(container).getTimestampsWriter();
    }

    public final SearcherManager findTimestampsSearcher(String container) {
        return this.getIndexContainer(container).getTimestampsSearcher();
    }

    public final void delete(String container) {
        this.deleteIndexContainer(container, false);
    }

    public final void delete(String container, String sourceModule) {
        if (this.fContainerMappings.getProperty(container) != null) {
            this.getIndexContainer(container).delete(sourceModule);
        }
    }

    private synchronized List<IndexContainer> getDirtyContainers() {
        ArrayList<IndexContainer> uncommittedContainers = new ArrayList<IndexContainer>();
        for (IndexContainer indexContainer : this.fIndexContainers.values()) {
            if (!indexContainer.hasChanges()) continue;
            uncommittedContainers.add(indexContainer);
        }
        return uncommittedContainers;
    }

    private synchronized IndexContainer getIndexContainer(String container) {
        String containerId = this.fContainerMappings.getProperty(container);
        if (containerId == null) {
            while (this.fContainerMappings.containsValue(containerId = UUID.randomUUID().toString())) {
            }
            this.fContainerMappings.put(container, containerId);
            this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
            this.saveMappings();
        }
        return this.fIndexContainers.get(containerId);
    }

    private synchronized void deleteIndexContainer(String container, boolean wait) {
        String containerId = (String)this.fContainerMappings.remove(container);
        if (containerId != null) {
            IndexContainer containerEntry = this.fIndexContainers.remove(containerId);
            this.saveMappings();
            containerEntry.delete(wait);
        }
    }

    private synchronized void startup() {
        this.loadProperties();
        boolean purgeIndexRoot = false;
        boolean resetProperties = false;
        String modelVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.model.version");
        String luceneVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.lucene.version");
        if (!"1.0".equals(modelVersion) || !IndexProperties.LUCENE_VERSION.equals(luceneVersion)) {
            purgeIndexRoot = true;
            resetProperties = true;
        }
        if (purgeIndexRoot) {
            this.purge();
        }
        if (resetProperties) {
            this.resetProperties();
            this.saveProperties();
        }
        this.loadMappings();
        this.registerIndexContainers();
        ModelManager.getModelManager().getIndexManager().addIndexerThreadListener((IIndexThreadListener)new IndexerThreadListener());
        ModelManager.getModelManager().getIndexManager().addShutdownListener((IShutdownListener)new ShutdownListener());
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant("org.eclipse.dltk.core.index.lucene", (ISaveParticipant)new SaveParticipant());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    private synchronized void shutdown() {
        for (IndexContainer entry : this.fIndexContainers.values()) {
            entry.close();
        }
        this.cleanup();
    }

    private void registerIndexContainers() {
        for (String container : this.fContainerMappings.stringPropertyNames()) {
            String containerId = this.fContainerMappings.getProperty(container);
            this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
        }
    }

    private void loadProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                this.fIndexProperties.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void loadMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                this.fContainerMappings.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void saveProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.fIndexProperties.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void saveMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.fContainerMappings.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void resetProperties() {
        this.fIndexProperties.clear();
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.model.version", "1.0");
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.lucene.version", IndexProperties.LUCENE_VERSION);
    }

    private void cleanup() {
        ArrayList<String> containers = new ArrayList<String>();
        IDLTKLanguageToolkit[] iDLTKLanguageToolkitArray = DLTKLanguageManager.getLanguageToolkits();
        int n = iDLTKLanguageToolkitArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDLTKLanguageToolkit toolkit = iDLTKLanguageToolkitArray[n2];
            DLTKWorkspaceScope scope = ModelManager.getModelManager().getWorkspaceScope(toolkit);
            IPath[] iPathArray = scope.enclosingProjectsAndZips();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                containers.add(path.toString());
                ++n4;
            }
            ++n2;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String mappedContainer : this.fContainerMappings.stringPropertyNames()) {
            if (containers.contains(mappedContainer)) continue;
            toRemove.add(mappedContainer);
        }
        if (!toRemove.isEmpty()) {
            for (String container : toRemove) {
                this.deleteIndexContainer(container, true);
            }
        }
        ArrayList<Path> toDelete = new ArrayList<Path>();
        Path indexRoot = Paths.get(this.fIndexRoot, new String[0]);
        File[] fileArray = indexRoot.toFile().listFiles();
        int path = fileArray.length;
        int n5 = 0;
        while (n5 < path) {
            File file = fileArray[n5];
            if (file.isDirectory() && !this.fContainerMappings.containsValue(file.getName())) {
                toDelete.add(Paths.get(file.getAbsolutePath(), new String[0]));
            }
            ++n5;
        }
        if (!toDelete.isEmpty()) {
            for (Path path2 : toDelete) {
                try {
                    Utils.delete(path2);
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
        }
    }

    private void purge() {
        Path indexRoot = Paths.get(this.fIndexRoot, new String[0]);
        try {
            Utils.delete(indexRoot);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        indexRoot.toFile().mkdir();
    }

    private final class Committer
    extends Job {
        private static final int DELAY = 5000;
        private boolean fClosed;

        public Committer() {
            super("");
            this.fClosed = false;
            this.setUser(false);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            List dirtyContainers = LuceneManager.this.getDirtyContainers();
            if (dirtyContainers.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            int containersNumber = dirtyContainers.size();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)containersNumber);
            try {
                for (IndexContainer indexContainer : dirtyContainers) {
                    if (monitor.isCanceled()) continue;
                    indexContainer.commit((IProgressMonitor)subMonitor.newChild(1), false);
                }
                monitor.done();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == LucenePlugin.LUCENE_JOB_FAMILY;
        }

        synchronized void commit() {
            if (this.fClosed) {
                return;
            }
            int currentState = this.getState();
            if (currentState == 0) {
                this.schedule(5000L);
            } else if (currentState == 1) {
                this.wakeUp(5000L);
            } else if (currentState == 2) {
                this.sleep();
                this.wakeUp(5000L);
            } else {
                this.cancel();
                this.schedule(5000L);
            }
        }

        synchronized void close() {
            if (!this.fClosed) {
                this.cancel();
                this.fClosed = true;
            }
        }
    }

    private final class IndexerThreadListener
    implements IIndexThreadListener {
        private IndexerThreadListener() {
        }

        public void aboutToBeIdle() {
            LuceneManager.this.fCommitter.commit();
        }

        public void aboutToBeRun(long idlingTime) {
        }
    }

    private final class SaveParticipant
    implements ISaveParticipant {
        private SaveParticipant() {
        }

        public void saving(ISaveContext context) throws CoreException {
            if (context.getKind() != 1) {
                return;
            }
            LuceneManager.this.fCommitter.close();
            for (IndexContainer indexContainer : LuceneManager.this.fIndexContainers.values()) {
                indexContainer.commit((IProgressMonitor)new NullProgressMonitor(), true);
            }
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }
    }

    private final class ShutdownListener
    implements IShutdownListener {
        private ShutdownListener() {
        }

        public void shutdown() {
            LuceneManager.this.fCommitter.close();
            INSTANCE.shutdown();
        }
    }
}

