/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import java.io.Reader;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.ui.typeinfo.ElementLabelProviderRegistry;
import org.eclipse.dltk.javascript.ui.typeinfo.IElementLabelProvider;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension2;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;

public class ElementDocumentationProvider
implements IScriptDocumentationProvider,
IScriptDocumentationProviderExtension2 {
    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        return null;
    }

    public Reader getInfo(String content) {
        return null;
    }

    public IDocumentationResponse getDocumentationFor(Object element) {
        if (element instanceof Element) {
            Element jsElement = (Element)element;
            return new TextDocumentationResponse(element, this.getElementTitle(jsElement), this.getElementImageDescriptor(jsElement), jsElement.getDescription() != null ? jsElement.getDescription() : "");
        }
        return null;
    }

    private boolean appendDeclaringTypePath(StringBuilder sb, EObject object) {
        if (object instanceof RecordType) {
            return this.appendDeclaringTypePath(sb, object.eContainer());
        }
        if (object instanceof Type) {
            if (object.eContainer() instanceof RecordType) {
                return this.appendDeclaringTypePath(sb, object.eContainer());
            }
            Type type = (Type)object;
            sb.append(type.getName());
            sb.append(".");
            return true;
        }
        if (object instanceof Member && this.appendDeclaringTypePath(sb, object.eContainer())) {
            Member member = (Member)object;
            sb.append(member.getName());
            sb.append(".");
            return true;
        }
        return false;
    }

    protected String getElementTitle(Element element) {
        Member member;
        String label = ElementLabelProviderRegistry.getLabel(element, IElementLabelProvider.Mode.TITLE);
        if (label != null) {
            return label;
        }
        StringBuilder sb = new StringBuilder();
        if (element instanceof Member && (member = (Member)element).getDeclaringType() != null) {
            if (TypeUtil.isDeclaringTypeVisible((Member)member)) {
                sb.append(member.getDeclaringType().getName());
                sb.append('.');
            } else {
                this.appendDeclaringTypePath(sb, (EObject)member.getDeclaringType());
            }
        }
        sb.append(element.getName());
        if (element instanceof Property) {
            Property property = (Property)element;
            if (TypeUtil.isValueTypeVisible((JSType)property.getType())) {
                sb.append(": ");
                sb.append(property.getType().getName());
            }
        } else if (element instanceof Method) {
            Method method = (Method)element;
            sb.append('(');
            int paramCount = 0;
            for (Parameter parameter : method.getParameters()) {
                if (paramCount != 0) {
                    sb.append(", ");
                }
                sb.append(parameter.getName());
                if (parameter.getType() != null) {
                    sb.append(':');
                    sb.append(parameter.getType().getName());
                    if (parameter.getKind() == ParameterKind.VARARGS) {
                        sb.append("...");
                    }
                } else if (parameter.getKind() == ParameterKind.VARARGS) {
                    sb.append("...");
                }
                ++paramCount;
            }
            sb.append(')');
            if (method.getType() != null) {
                sb.append(": ");
                sb.append(method.getType().getName());
            }
        }
        return sb.toString();
    }

    protected ImageDescriptor getElementImageDescriptor(Element element) {
        ImageDescriptor descriptor = ElementLabelProviderRegistry.getImageDescriptor(element);
        if (descriptor != null) {
            return descriptor;
        }
        if (element instanceof Type) {
            return this.decorateImageDescriptor(ScriptElementImageProvider.getTypeImageDescriptor((int)0, (boolean)false), element);
        }
        if (element instanceof Member) {
            int flags = ((Member)element).getVisibility().getFlags();
            if (element instanceof Property) {
                return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor((int)flags), element);
            }
            if (element instanceof Method) {
                return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor((int)flags), element);
            }
        }
        return null;
    }

    protected ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, Element element) {
        if (element.isDeprecated()) {
            return new ScriptElementImageDescriptor(descriptor, 1024, ScriptElementImageProvider.SMALL_SIZE);
        }
        if (element instanceof Member && ((Member)element).isStatic()) {
            return new ScriptElementImageDescriptor(descriptor, 8, ScriptElementImageProvider.SMALL_SIZE);
        }
        return descriptor;
    }
}

