/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.BundleContext;

public class TclDebugPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.tcl.debug";
    private static TclDebugPlugin fgPlugin;
    public static final int INTERNAL_ERROR = 120;
    private boolean fTrace = false;

    public static void log(IStatus status) {
        TclDebugPlugin.getDefault().getLog().log(status);
    }

    public boolean isTraceMode() {
        return this.fTrace;
    }

    public static void logTraceMessage(String message) {
        if (TclDebugPlugin.getDefault().isTraceMode()) {
            Status s = new Status(2, PLUGIN_ID, 120, message, null);
            TclDebugPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public static TclDebugPlugin getDefault() {
        return fgPlugin;
    }

    public TclDebugPlugin() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.savePluginPreferences();
        }
        finally {
            fgPlugin = null;
            super.stop(context);
        }
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        TclDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, 120, "Internal error logged from Tcl Debug: ", top));
    }
}

