/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinfo.DefaultMetaType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.MetaType;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.impl.ElementImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class TypeImpl
extends ElementImpl
implements Type {
    protected EList<Member> members;
    protected static final TypeKind KIND_EDEFAULT = TypeKind.DEFAULT;
    protected TypeKind kind = KIND_EDEFAULT;
    protected SimpleType superTypeExpr;
    protected Constructor staticConstructor;
    protected EList<Type> traits;
    protected EList<Constructor> constructors;
    protected static final boolean INSTANTIABLE_EDEFAULT = true;
    protected boolean instantiable = true;
    protected static final boolean INHERIT_CONSTRUCTORS_EDEFAULT = false;
    protected static final boolean INHERIT_STATIC_MEMBERS_EDEFAULT = false;
    protected static final MetaType META_TYPE_EDEFAULT = DefaultMetaType.DEFAULT;
    protected MetaType metaType = META_TYPE_EDEFAULT;

    protected TypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypeInfoModelPackage.Literals.TYPE;
    }

    @Override
    public EList<Member> getMembers() {
        if (this.members == null) {
            this.members = new EObjectContainmentWithInverseEList(Member.class, (InternalEObject)this, 6, 9);
        }
        return this.members;
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            return URI.decode((String)this.eProxyURI().fragment());
        }
        return super.getName();
    }

    @Override
    public TypeKind getKind() {
        if (this.isProxy()) {
            return TypeKind.UNRESOLVED;
        }
        return this.kind;
    }

    @Override
    public void setKind(TypeKind newKind) {
        TypeKind oldKind = this.kind;
        TypeKind typeKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public Type getSuperType() {
        return this.superTypeExpr != null ? this.superTypeExpr.getTarget() : null;
    }

    @Override
    public void setSuperType(Type newSuperType) {
        this.setSuperTypeExpr(TypeUtil.ref(newSuperType));
    }

    @Override
    public SimpleType getSuperTypeExpr() {
        return this.superTypeExpr;
    }

    public NotificationChain basicSetSuperTypeExpr(SimpleType newSuperTypeExpr, NotificationChain msgs) {
        SimpleType oldSuperTypeExpr = this.superTypeExpr;
        this.superTypeExpr = newSuperTypeExpr;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSuperTypeExpr, (Object)newSuperTypeExpr);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSuperTypeExpr(SimpleType newSuperTypeExpr) {
        if (newSuperTypeExpr != this.superTypeExpr) {
            NotificationChain msgs = null;
            if (this.superTypeExpr != null) {
                msgs = ((InternalEObject)this.superTypeExpr).eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newSuperTypeExpr != null) {
                msgs = ((InternalEObject)newSuperTypeExpr).eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetSuperTypeExpr(newSuperTypeExpr, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newSuperTypeExpr, (Object)newSuperTypeExpr));
        }
    }

    @Override
    public Constructor getStaticConstructor() {
        return this.staticConstructor;
    }

    public NotificationChain basicSetStaticConstructor(Constructor newStaticConstructor, NotificationChain msgs) {
        Constructor oldStaticConstructor = this.staticConstructor;
        this.staticConstructor = newStaticConstructor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldStaticConstructor, (Object)newStaticConstructor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStaticConstructor(Constructor newStaticConstructor) {
        if (newStaticConstructor != this.staticConstructor) {
            NotificationChain msgs = null;
            if (this.staticConstructor != null) {
                msgs = ((InternalEObject)this.staticConstructor).eInverseRemove((InternalEObject)this, -11, null, msgs);
            }
            if (newStaticConstructor != null) {
                msgs = ((InternalEObject)newStaticConstructor).eInverseAdd((InternalEObject)this, -11, null, msgs);
            }
            if ((msgs = this.basicSetStaticConstructor(newStaticConstructor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newStaticConstructor, (Object)newStaticConstructor));
        }
    }

    @Override
    public EList<Type> getTraits() {
        if (this.traits == null) {
            this.traits = new EObjectResolvingEList(Type.class, (InternalEObject)this, 11);
        }
        return this.traits;
    }

    @Override
    public EList<Constructor> getConstructors() {
        if (this.constructors == null) {
            this.constructors = new EObjectContainmentEList(Constructor.class, (InternalEObject)this, 12);
        }
        return this.constructors;
    }

    @Override
    public boolean isInstantiable() {
        return this.instantiable;
    }

    @Override
    public void setInstantiable(boolean newInstantiable) {
        boolean oldInstantiable = this.instantiable;
        this.instantiable = newInstantiable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldInstantiable, this.instantiable));
        }
    }

    @Override
    public boolean isInheritConstructors() {
        return false;
    }

    @Override
    public boolean isInheritStaticMembers() {
        return this.getKind() == TypeKind.JAVA;
    }

    @Override
    public MetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public void setMetaType(MetaType newMetaType) {
        MetaType oldMetaType = this.metaType;
        this.metaType = newMetaType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldMetaType, (Object)this.metaType));
        }
    }

    @Override
    public boolean isProxy() {
        return this.eIsProxy();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getMembers()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getMembers()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return this.basicSetSuperTypeExpr(null, msgs);
            }
            case 10: {
                return this.basicSetStaticConstructor(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getConstructors()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getMembers();
            }
            case 7: {
                return this.getKind();
            }
            case 8: {
                return this.getSuperType();
            }
            case 9: {
                return this.getSuperTypeExpr();
            }
            case 10: {
                return this.getStaticConstructor();
            }
            case 11: {
                return this.getTraits();
            }
            case 12: {
                return this.getConstructors();
            }
            case 13: {
                return this.isInstantiable();
            }
            case 14: {
                return this.isInheritConstructors();
            }
            case 15: {
                return this.isInheritStaticMembers();
            }
            case 16: {
                return this.getMetaType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getMembers().clear();
                this.getMembers().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setKind((TypeKind)((Object)newValue));
                return;
            }
            case 8: {
                this.setSuperType((Type)newValue);
                return;
            }
            case 9: {
                this.setSuperTypeExpr((SimpleType)newValue);
                return;
            }
            case 10: {
                this.setStaticConstructor((Constructor)newValue);
                return;
            }
            case 11: {
                this.getTraits().clear();
                this.getTraits().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getConstructors().clear();
                this.getConstructors().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setInstantiable((Boolean)newValue);
                return;
            }
            case 16: {
                this.setMetaType((MetaType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getMembers().clear();
                return;
            }
            case 7: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 8: {
                this.setSuperType(null);
                return;
            }
            case 9: {
                this.setSuperTypeExpr(null);
                return;
            }
            case 10: {
                this.setStaticConstructor(null);
                return;
            }
            case 11: {
                this.getTraits().clear();
                return;
            }
            case 12: {
                this.getConstructors().clear();
                return;
            }
            case 13: {
                this.setInstantiable(true);
                return;
            }
            case 16: {
                this.setMetaType(META_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.members != null && !this.members.isEmpty();
            }
            case 7: {
                return this.kind != KIND_EDEFAULT;
            }
            case 8: {
                return this.getSuperType() != null;
            }
            case 9: {
                return this.superTypeExpr != null;
            }
            case 10: {
                return this.staticConstructor != null;
            }
            case 11: {
                return this.traits != null && !this.traits.isEmpty();
            }
            case 12: {
                return this.constructors != null && !this.constructors.isEmpty();
            }
            case 13: {
                return !this.instantiable;
            }
            case 14: {
                return this.isInheritConstructors();
            }
            case 15: {
                return this.isInheritStaticMembers();
            }
            case 16: {
                return META_TYPE_EDEFAULT == null ? this.metaType != null : !META_TYPE_EDEFAULT.equals(this.metaType);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return String.valueOf(this.eClass().getName()) + "(eProxyURI=" + this.eProxyURI() + ')';
        }
        StringBuffer result = new StringBuffer(this.eClass().getName());
        result.append('<');
        result.append(this.name);
        result.append('>');
        return result.toString();
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return TypeUtil.resolve(proxy, this);
    }

    @Override
    public MemberPredicate memberPredicateFor(IRType type, MemberPredicate predicate) {
        return predicate;
    }

    @Override
    public IRType createInstance(ITypeSystem typeSystem) {
        return this.toRType(typeSystem);
    }

    @Override
    public IRType toRType(ITypeSystem typeSystem) {
        return (this.metaType != null ? this.metaType : DefaultMetaType.DEFAULT).toRType(typeSystem, this);
    }

    @Override
    public Member[] getAdditionalMembers(@Nullable List<IRType> parameters) {
        return null;
    }

    @Override
    public IAssignProtection getReadOnlyStatus(Property property) {
        return property.isReadOnly() ? ElementValue.READONLY_PROPERTY : null;
    }

    @Override
    public Member findDirectMember(String name) {
        for (Member member : this.getMembers()) {
            if (!name.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    @Override
    public boolean hasPrototype() {
        return this.kind == TypeKind.PREDEFINED || this.kind == TypeKind.JAVASCRIPT;
    }

    @Override
    public Type getPrototypeType() {
        return this.isInstantiable() ? Types.FUNCTION : Types.OBJECT;
    }
}

