/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.NthRefNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.HeredocTerm;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionFactory;
import org.jruby.lexer.yacc.Keyword;
import org.jruby.lexer.yacc.LexState;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.StackState;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.StaticScope;
import org.jruby.util.IdUtil;

public class RubyYaccLexer {
    private int token;
    Object yaccValue;
    private LexerSource src;
    private ParserSupport parserSupport = null;
    private IRubyWarnings warnings;
    private LexState lex_state;
    private StringBuffer tokenBuffer = new StringBuffer(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    private boolean commandStart;
    static final int EOF = 0;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private final int str_squote = 0;
    private final int str_dquote = 2;
    private final int str_xquote = 2;
    private final int str_regexp = 7;
    private final int str_ssym = 16;
    private final int str_dsym = 18;

    public RubyYaccLexer() {
        this.reset();
    }

    public void reset() {
        this.token = 0;
        this.yaccValue = null;
        this.src = null;
        this.lex_state = null;
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
    }

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != 0;
    }

    public int token() {
        return this.token;
    }

    public StringBuffer getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.src.getPositionFactory();
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.src.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.src.getPosition(null, false);
    }

    public void setParserSupport(ParserSupport parserSupport) {
        this.parserSupport = parserSupport;
    }

    public void setSource(LexerSource source) {
        this.src = source;
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setState(LexState state) {
        this.lex_state = state;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    private boolean isNext_identchar() throws IOException {
        char c = this.src.read();
        this.src.unread(c);
        return c != '\u0000' && (Character.isLetterOrDigit(c) || c == '-');
    }

    private Object getInteger(String value, int radix) {
        try {
            return new FixnumNode(this.getPosition(), Long.parseLong(value, radix));
        }
        catch (NumberFormatException e) {
            return new BignumNode(this.getPosition(), new BigInteger(value, radix));
        }
    }

    private String isNextNoCase(String s) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            char r = this.src.read();
            buf.append(r);
            if (Character.toLowerCase(c) != r && Character.toUpperCase(c) != r) {
                this.src.unreadMany(buf);
                return null;
            }
            ++i;
        }
        return buf.toString();
    }

    static final boolean isHexChar(char c) {
        return Character.isDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static final boolean isOctChar(char c) {
        return '0' <= c && c <= '7';
    }

    private static final boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private int parseQuote(char c) throws IOException {
        char end;
        boolean shortHand;
        char begin;
        if (!Character.isLetterOrDigit(c)) {
            begin = c;
            c = (char)81;
            shortHand = true;
        } else {
            shortHand = false;
            begin = this.src.read();
            if (Character.isLetterOrDigit(begin)) {
                throw new SyntaxException(this.getPosition(), "unknown type of %string");
            }
        }
        if (c == '\u0000' || begin == '\u0000') {
            throw new SyntaxException(this.getPosition(), "unterminated quoted string meets end of file");
        }
        if (begin == '(') {
            end = ')';
        } else if (begin == '[') {
            end = ']';
        } else if (begin == '{') {
            end = '}';
        } else if (begin == '<') {
            end = '>';
        } else {
            end = begin;
            begin = '\u0000';
        }
        switch (c) {
            case 'Q': {
                this.lex_strterm = new StringTerm(2, end, begin);
                this.yaccValue = new Token("%" + (shortHand ? "" + end : "" + c + begin), this.getPosition());
                return 367;
            }
            case 'q': {
                this.lex_strterm = new StringTerm(0, end, begin);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 367;
            }
            case 'W': {
                this.lex_strterm = new StringTerm(10, end, begin);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 370;
            }
            case 'w': {
                this.lex_strterm = new StringTerm(8, end, begin);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 371;
            }
            case 'x': {
                this.lex_strterm = new StringTerm(2, end, begin);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 368;
            }
            case 'r': {
                this.lex_strterm = new StringTerm(7, end, begin);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 369;
            }
            case 's': {
                this.lex_strterm = new StringTerm(16, end, begin);
                this.lex_state = LexState.EXPR_FNAME;
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 366;
            }
        }
        throw new SyntaxException(this.getPosition(), "Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private int hereDocumentIdentifier() throws IOException {
        char term;
        int func;
        block11: {
            char c;
            block10: {
                char c2;
                block9: {
                    block8: {
                        c = this.src.read();
                        func = 0;
                        if (c == '-') {
                            c = this.src.read();
                            func = 32;
                        }
                        if (c != '\'' && c != '\"' && c != '`') break block8;
                        func = c == '\'' ? (func |= 0) : (c == '\"' ? (func |= 2) : (func |= 2));
                        this.tokenBuffer.setLength(0);
                        term = c;
                        if (!true) break block9;
                        c2 = this.src.read();
                        c = c2;
                        if (c2 == '\u0000' || c == term) break block10;
                    }
                    if (!RubyYaccLexer.isIdentifierChar(c)) {
                        this.src.unread(c);
                        if ((func & 0x20) != 0) {
                            this.src.unread('-');
                        }
                        return 0;
                    }
                    this.tokenBuffer.setLength(0);
                    term = '\"';
                    func |= 2;
                    do {
                        this.tokenBuffer.append(c);
                    } while ((c = this.src.read()) != '\u0000' && RubyYaccLexer.isIdentifierChar(c));
                    this.src.unread(c);
                    break block11;
                }
                do {
                    this.tokenBuffer.append(c);
                    c2 = this.src.read();
                    c = c2;
                } while (c2 != '\u0000' && c != term);
            }
            if (c == '\u0000') {
                throw new SyntaxException(this.getPosition(), "unterminated here document identifier");
            }
        }
        String line = String.valueOf(this.src.readLine()) + '\n';
        String tok = this.tokenBuffer.toString();
        this.lex_strterm = new HeredocTerm(tok, func, line);
        if (term == '`') {
            this.yaccValue = new Token("`", this.getPosition());
            return 368;
        }
        this.yaccValue = new Token("\"", this.getPosition());
        this.getPosition();
        return 367;
    }

    private void arg_ambiguous() {
        this.warnings.warning(this.getPosition(), "Ambiguous first argument; make sure.");
    }

    protected int readComment(char c) throws IOException {
        ISourcePosition startPosition = this.src.getPosition();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append(c);
        while ((c = this.src.read()) != '\n') {
            this.tokenBuffer.append(c);
            if (c == '\u0000') break;
        }
        this.src.unread(c);
        ISourcePosition position = startPosition.union(this.getPosition());
        this.parserSupport.getResult().addComment(new CommentNode(position, this.tokenBuffer.toString()));
        return c;
    }

    private int yylex() throws IOException {
        char c;
        boolean spaceSeen = false;
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this, this.src);
            if (tok == 374 || tok == 315) {
                this.lex_strterm = null;
                this.lex_state = LexState.EXPR_END;
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        LexState last_state = this.lex_state;
        block61: while (true) {
            c = this.src.read();
            switch (c) {
                case '\u0000': 
                case '\u0004': 
                case '\u001a': {
                    return 0;
                }
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.getPosition();
                    spaceSeen = true;
                    continue block61;
                }
                case '#': {
                    if (this.readComment(c) == 0) {
                        return 0;
                    }
                }
                case '\n': {
                    char c2;
                    do {
                        c2 = this.src.read();
                        c = c2;
                    } while (c2 == '\n');
                    this.src.unread(c);
                    this.getPosition();
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT || this.lex_state == LexState.EXPR_CLASS) continue block61;
                    this.commandStart = true;
                    this.lex_state = LexState.EXPR_BEG;
                    return 10;
                }
                case '*': {
                    char c3 = this.src.read();
                    c = c3;
                    if (c3 == '*') {
                        c = this.src.read();
                        if (c == '=') {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token("**", this.getPosition());
                            return 339;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("**", this.getPosition());
                        c = '\u013f';
                    } else {
                        if (c == '=') {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token("*", this.getPosition());
                            return 339;
                        }
                        this.src.unread(c);
                        if (this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                            this.warnings.warning(this.getPosition(), "`*' interpreted as argument prefix");
                            c = '\u015d';
                        } else {
                            c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? (char)'\u015d' : '\u015e';
                        }
                        this.yaccValue = new Token("*", this.getPosition());
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return c;
                }
                case '!': {
                    this.lex_state = LexState.EXPR_BEG;
                    char c4 = this.src.read();
                    c = c4;
                    if (c4 == '=') {
                        this.yaccValue = new Token("!=", this.getPosition());
                        return 323;
                    }
                    if (c == '~') {
                        this.yaccValue = new Token("!~", this.getPosition());
                        return 329;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("!", this.getPosition());
                    return 361;
                }
                case '=': {
                    String equalLabel;
                    if (this.src.wasBeginOfLine() && (equalLabel = this.isNextNoCase("begin")) != null) {
                        this.tokenBuffer.setLength(0);
                        this.tokenBuffer.append(equalLabel);
                        c = this.src.read();
                        if (Character.isWhitespace(c)) {
                            this.src.unread(c);
                            do {
                                c = this.src.read();
                                this.tokenBuffer.append(c);
                                while (c == '\n') {
                                    c = this.src.read();
                                    this.tokenBuffer.append(c);
                                }
                                if (c != '\u0000') continue;
                                throw new SyntaxException(this.getPosition(), "embedded document meets end of file");
                            } while (c != '=' || !this.src.wasBeginOfLine() || (equalLabel = this.isNextNoCase("end")) == null);
                            this.tokenBuffer.append(equalLabel);
                            this.tokenBuffer.append(this.src.readLine());
                            this.src.unread('\n');
                            this.parserSupport.getResult().addComment(new CommentNode(this.getPosition(), this.tokenBuffer.toString()));
                            continue block61;
                        }
                        this.src.unread(c);
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.src.read();
                    if (c == '=') {
                        c = this.src.read();
                        if (c == '=') {
                            this.yaccValue = new Token("===", this.getPosition());
                            return 322;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("==", this.getPosition());
                        return 321;
                    }
                    if (c == '~') {
                        this.yaccValue = new Token("=~", this.getPosition());
                        return 328;
                    }
                    if (c == '>') {
                        this.yaccValue = new Token("=>", this.getPosition());
                        return 340;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("=", this.getPosition());
                    return 61;
                }
                case '<': {
                    int tok;
                    c = this.src.read();
                    if (c == '<' && this.lex_state != LexState.EXPR_END && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_ENDARG && this.lex_state != LexState.EXPR_CLASS && (!this.lex_state.isArgument() || spaceSeen) && (tok = this.hereDocumentIdentifier()) != 0) {
                        return tok;
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    if (c == '=') {
                        c = this.src.read();
                        if (c == '>') {
                            this.yaccValue = new Token("<=>", this.getPosition());
                            return 320;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("<=", this.getPosition());
                        return 325;
                    }
                    if (c == '<') {
                        c = this.src.read();
                        if (c == '=') {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token("<<", this.getPosition());
                            return 339;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("<<", this.getPosition());
                        return 335;
                    }
                    this.yaccValue = new Token("<", this.getPosition());
                    this.src.unread(c);
                    return 358;
                }
                case '>': {
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.src.read();
                    if (c == '=') {
                        this.yaccValue = new Token(">=", this.getPosition());
                        return 324;
                    }
                    if (c == '>') {
                        c = this.src.read();
                        if (c == '=') {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token(">>", this.getPosition());
                            return 339;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token(">>", this.getPosition());
                        return 336;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token(">", this.getPosition());
                    return 359;
                }
                case '\"': {
                    this.lex_strterm = new StringTerm(2, '\"', '\u0000');
                    this.yaccValue = new Token("\"", this.getPosition());
                    return 367;
                }
                case '`': {
                    this.yaccValue = new Token("`", this.getPosition());
                    if (this.lex_state == LexState.EXPR_FNAME) {
                        this.lex_state = LexState.EXPR_END;
                        return 365;
                    }
                    if (this.lex_state == LexState.EXPR_DOT) {
                        this.lex_state = commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                        return 365;
                    }
                    this.lex_strterm = new StringTerm(2, '`', '\u0000');
                    return 368;
                }
                case '\'': {
                    this.lex_strterm = new StringTerm(0, '\'', '\u0000');
                    this.yaccValue = new Token("'", this.getPosition());
                    return 367;
                }
                case '?': {
                    if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG) {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("?", this.getPosition());
                        return 63;
                    }
                    c = this.src.read();
                    if (c == '\u0000') {
                        throw new SyntaxException(this.getPosition(), "incomplete character syntax");
                    }
                    if (Character.isWhitespace(c)) {
                        if (!this.lex_state.isArgument()) {
                            int c2 = 0;
                            switch (c) {
                                case ' ': {
                                    c2 = 115;
                                    break;
                                }
                                case '\n': {
                                    c2 = 110;
                                    break;
                                }
                                case '\t': {
                                    c2 = 116;
                                    break;
                                }
                                case '\r': {
                                    c2 = 114;
                                    break;
                                }
                                case '\f': {
                                    c2 = 102;
                                }
                            }
                            if (c2 != 0) {
                                this.warnings.warn(this.getPosition(), "invalid character syntax; use ?\\" + c2);
                            }
                        }
                        this.src.unread(c);
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("?", this.getPosition());
                        return 63;
                    }
                    if ((Character.isLetterOrDigit(c) || c == '_') && !this.src.peek('\n') && this.isNext_identchar()) {
                        this.src.unread(c);
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("?", this.getPosition());
                        return 63;
                    }
                    if (c == '\\') {
                        c = this.src.readEscape();
                    }
                    c = (char)(c & 0xFF);
                    this.lex_state = LexState.EXPR_END;
                    this.yaccValue = new FixnumNode(this.getPosition(), (long)c);
                    return 313;
                }
                case '&': {
                    char c5 = this.src.read();
                    c = c5;
                    if (c5 == '&') {
                        this.lex_state = LexState.EXPR_BEG;
                        char c6 = this.src.read();
                        c = c6;
                        if (c6 == '=') {
                            this.yaccValue = new Token("&&", this.getPosition());
                            this.lex_state = LexState.EXPR_BEG;
                            return 339;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("&&", this.getPosition());
                        return 326;
                    }
                    if (c == '=') {
                        this.yaccValue = new Token("&", this.getPosition());
                        this.lex_state = LexState.EXPR_BEG;
                        return 339;
                    }
                    this.src.unread(c);
                    ISourcePosition tmpPosition = this.getPosition();
                    if (this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                        this.warnings.warning(tmpPosition, "`&' interpreted as argument prefix");
                        c = '\u015f';
                    } else {
                        c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? (char)'\u015f' : '\u0160';
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.yaccValue = new Token("&", tmpPosition);
                    return c;
                }
                case '|': {
                    char c7 = this.src.read();
                    c = c7;
                    if (c7 == '|') {
                        this.lex_state = LexState.EXPR_BEG;
                        char c8 = this.src.read();
                        c = c8;
                        if (c8 == '=') {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token("||", this.getPosition());
                            return 339;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("||", this.getPosition());
                        return 327;
                    }
                    if (c == '=') {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("|", this.getPosition());
                        return 339;
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.src.unread(c);
                    this.yaccValue = new Token("|", this.getPosition());
                    return 360;
                }
                case '+': {
                    c = this.src.read();
                    if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
                        this.lex_state = LexState.EXPR_ARG;
                        if (c == '@') {
                            this.yaccValue = new Token("+@", this.getPosition());
                            return 316;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("+", this.getPosition());
                        return 356;
                    }
                    if (c == '=') {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("+", this.getPosition());
                        return 339;
                    }
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                        if (this.lex_state.isArgument()) {
                            this.arg_ambiguous();
                        }
                        this.lex_state = LexState.EXPR_BEG;
                        this.src.unread(c);
                        if (Character.isDigit(c)) {
                            c = '+';
                            return this.parseNumber(c);
                        }
                        this.yaccValue = new Token("+", this.getPosition());
                        return 316;
                    }
                    this.lex_state = LexState.EXPR_BEG;
                    this.src.unread(c);
                    this.yaccValue = new Token("+", this.getPosition());
                    return 356;
                }
                case '-': {
                    c = this.src.read();
                    if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
                        this.lex_state = LexState.EXPR_ARG;
                        if (c == '@') {
                            this.yaccValue = new Token("-@", this.getPosition());
                            return 317;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("-", this.getPosition());
                        return 357;
                    }
                    if (c == '=') {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("-", this.getPosition());
                        return 339;
                    }
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                        if (this.lex_state.isArgument()) {
                            this.arg_ambiguous();
                        }
                        this.lex_state = LexState.EXPR_BEG;
                        this.src.unread(c);
                        this.yaccValue = new Token("-", this.getPosition());
                        if (Character.isDigit(c)) {
                            return 318;
                        }
                        return 317;
                    }
                    this.lex_state = LexState.EXPR_BEG;
                    this.src.unread(c);
                    this.yaccValue = new Token("-", this.getPosition());
                    return 357;
                }
                case '.': {
                    this.lex_state = LexState.EXPR_BEG;
                    char c9 = this.src.read();
                    c = c9;
                    if (c9 == '.') {
                        char c10 = this.src.read();
                        c = c10;
                        if (c10 == '.') {
                            this.yaccValue = new Token("...", this.getPosition());
                            return 332;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("..", this.getPosition());
                        return 331;
                    }
                    this.src.unread(c);
                    if (Character.isDigit(c)) {
                        throw new SyntaxException(this.getPosition(), "no .<digit> floating literal anymore; put 0 before dot");
                    }
                    this.lex_state = LexState.EXPR_DOT;
                    this.yaccValue = new Token(".", this.getPosition());
                    return 330;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.parseNumber(c);
                }
                case ')': {
                    this.conditionState.restart();
                    this.cmdArgumentState.restart();
                    this.lex_state = LexState.EXPR_END;
                    this.yaccValue = new Token(")", this.getPosition());
                    return 343;
                }
                case ']': {
                    this.conditionState.restart();
                    this.cmdArgumentState.restart();
                    this.lex_state = LexState.EXPR_END;
                    this.yaccValue = new Token(")", this.getPosition());
                    return 346;
                }
                case '}': {
                    this.conditionState.restart();
                    this.cmdArgumentState.restart();
                    this.lex_state = LexState.EXPR_END;
                    this.yaccValue = new Token("}", this.getPosition());
                    return 364;
                }
                case ':': {
                    c = this.src.read();
                    if (c == ':') {
                        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || this.lex_state.isArgument() && spaceSeen) {
                            this.lex_state = LexState.EXPR_BEG;
                            this.yaccValue = new Token("::", this.getPosition());
                            return 338;
                        }
                        this.lex_state = LexState.EXPR_DOT;
                        this.yaccValue = new Token(":", this.getPosition());
                        return 337;
                    }
                    if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || Character.isWhitespace(c)) {
                        this.src.unread(c);
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token(":", this.getPosition());
                        return 58;
                    }
                    switch (c) {
                        case '\'': {
                            this.lex_strterm = new StringTerm(16, c, '\u0000');
                            break;
                        }
                        case '\"': {
                            this.lex_strterm = new StringTerm(18, c, '\u0000');
                            break;
                        }
                        default: {
                            this.src.unread(c);
                        }
                    }
                    this.lex_state = LexState.EXPR_FNAME;
                    this.yaccValue = new Token(":", this.getPosition());
                    return 366;
                }
                case '/': {
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
                        this.lex_strterm = new StringTerm(7, '/', '\u0000');
                        this.yaccValue = new Token("/", this.getPosition());
                        return 369;
                    }
                    c = this.src.read();
                    if (c == '=') {
                        this.yaccValue = new Token("/", this.getPosition());
                        this.lex_state = LexState.EXPR_BEG;
                        return 339;
                    }
                    this.src.unread(c);
                    if (this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                        this.arg_ambiguous();
                        this.lex_strterm = new StringTerm(7, '/', '\u0000');
                        this.yaccValue = new Token("/", this.getPosition());
                        return 369;
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.yaccValue = new Token("/", this.getPosition());
                    return 355;
                }
                case '^': {
                    char c11 = this.src.read();
                    c = c11;
                    if (c11 == '=') {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("^", this.getPosition());
                        return 339;
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.src.unread(c);
                    this.yaccValue = new Token("^", this.getPosition());
                    return 362;
                }
                case ';': {
                    this.commandStart = true;
                }
                case ',': {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token(",", this.getPosition());
                    return c;
                }
                case '~': {
                    if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
                        char c12 = this.src.read();
                        c = c12;
                        if (c12 != '@') {
                            this.src.unread(c);
                        }
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.yaccValue = new Token("~", this.getPosition());
                    return 353;
                }
                case '(': {
                    c = '\u0156';
                    this.commandStart = true;
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
                        c = '\u0155';
                    } else if (spaceSeen) {
                        if (this.lex_state == LexState.EXPR_CMDARG) {
                            c = '\u0158';
                        } else if (this.lex_state == LexState.EXPR_ARG) {
                            this.warnings.warn(this.getPosition(), "don't put space before argument parentheses");
                            c = '\u0156';
                        }
                    }
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("(", this.getPosition());
                    return c;
                }
                case '[': {
                    if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
                        this.lex_state = LexState.EXPR_ARG;
                        c = this.src.read();
                        if (c == ']') {
                            if (this.src.peek('=')) {
                                c = this.src.read();
                                this.yaccValue = new Token("[]=", this.getPosition());
                                return 334;
                            }
                            this.yaccValue = new Token("[]", this.getPosition());
                            return 333;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("[", this.getPosition());
                        return 91;
                    }
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
                        c = '\u0159';
                    } else if (this.lex_state.isArgument() && spaceSeen) {
                        c = '\u0159';
                    }
                    this.lex_state = LexState.EXPR_BEG;
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.yaccValue = new Token("[", this.getPosition());
                    return c;
                }
                case '{': {
                    c = '\u016b';
                    c = this.lex_state.isArgument() || this.lex_state == LexState.EXPR_END ? (char)'\u016b' : (this.lex_state == LexState.EXPR_ENDARG ? (char)'\u015c' : '\u015b');
                    this.conditionState.stop();
                    this.cmdArgumentState.stop();
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("{", this.getPosition());
                    return c;
                }
                case '\\': {
                    c = this.src.read();
                    if (c == '\n') {
                        spaceSeen = true;
                        continue block61;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("\\", this.getPosition());
                    return 92;
                }
                case '%': {
                    if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
                        return this.parseQuote(this.src.read());
                    }
                    c = this.src.read();
                    if (c == '=') {
                        this.lex_state = LexState.EXPR_BEG;
                        this.yaccValue = new Token("%", this.getPosition());
                        return 339;
                    }
                    if (this.lex_state.isArgument() && spaceSeen && !Character.isWhitespace(c)) {
                        return this.parseQuote(c);
                    }
                    this.lex_state = this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.src.unread(c);
                    this.yaccValue = new Token("%", this.getPosition());
                    return 354;
                }
                case '$': {
                    this.lex_state = LexState.EXPR_END;
                    this.tokenBuffer.setLength(0);
                    c = this.src.read();
                    switch (c) {
                        case '_': {
                            c = this.src.read();
                            if (RubyYaccLexer.isIdentifierChar(c)) {
                                this.tokenBuffer.append('$');
                                this.tokenBuffer.append('_');
                                break block61;
                            }
                            this.src.unread(c);
                            c = '_';
                        }
                        case '!': 
                        case '\"': 
                        case '$': 
                        case '*': 
                        case ',': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '\\': 
                        case '~': {
                            this.tokenBuffer.append('$');
                            this.tokenBuffer.append(c);
                            this.yaccValue = new Token(this.tokenBuffer.toString(), this.getPosition());
                            return 306;
                        }
                        case '-': {
                            this.tokenBuffer.append('$');
                            this.tokenBuffer.append(c);
                            c = this.src.read();
                            if (RubyYaccLexer.isIdentifierChar(c)) {
                                this.tokenBuffer.append(c);
                            } else {
                                this.src.unread(c);
                            }
                            this.yaccValue = new Token(this.tokenBuffer.toString(), this.getPosition());
                            return 306;
                        }
                        case '&': 
                        case '\'': 
                        case '+': 
                        case '`': {
                            this.yaccValue = new BackRefNode(this.getPosition(), c);
                            return 311;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.tokenBuffer.append('$');
                            do {
                                this.tokenBuffer.append(c);
                            } while (Character.isDigit(c = this.src.read()));
                            this.src.unread(c);
                            if (last_state == LexState.EXPR_FNAME) {
                                this.yaccValue = new Token(this.tokenBuffer.toString(), this.getPosition());
                                return 306;
                            }
                            this.yaccValue = new NthRefNode(this.getPosition(), Integer.parseInt(this.tokenBuffer.substring(1)));
                            return 310;
                        }
                        default: {
                            if (RubyYaccLexer.isIdentifierChar(c)) break;
                            this.src.unread(c);
                            this.yaccValue = new Token("$", this.getPosition());
                            return 36;
                        }
                        case '0': 
                    }
                    this.tokenBuffer.append('$');
                    break block61;
                }
                case '@': {
                    c = this.src.read();
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append('@');
                    if (c == '@') {
                        this.tokenBuffer.append('@');
                        c = this.src.read();
                    }
                    if (Character.isDigit(c)) {
                        if (this.tokenBuffer.length() == 1) {
                            throw new SyntaxException(this.getPosition(), "`@" + c + "' is not allowed as an instance variable name");
                        }
                        throw new SyntaxException(this.getPosition(), "`@@" + c + "' is not allowed as a class variable name");
                    }
                    if (RubyYaccLexer.isIdentifierChar(c)) break block61;
                    this.src.unread(c);
                    this.yaccValue = new Token("@", this.getPosition());
                    return 64;
                }
                case '_': {
                    if (this.src.wasBeginOfLine() && this.src.matchString("_END__\n", false)) {
                        this.parserSupport.getResult().setEndSeen(true);
                        return 0;
                    }
                    this.tokenBuffer.setLength(0);
                    break block61;
                }
                default: {
                    if (!RubyYaccLexer.isIdentifierChar(c)) {
                        throw new SyntaxException(this.getPosition(), "Invalid char `\\" + Integer.parseInt("" + c, 8) + "' in expression");
                    }
                    this.tokenBuffer.setLength(0);
                }
            }
            break;
        }
        do {
            this.tokenBuffer.append(c);
        } while (RubyYaccLexer.isIdentifierChar(c = this.src.read()));
        char peek = this.src.read();
        if ((c == '!' || c == '?') && RubyYaccLexer.isIdentifierChar(this.tokenBuffer.charAt(0)) && peek != '=') {
            this.src.unread(peek);
            this.tokenBuffer.append(c);
        } else {
            this.src.unread(peek);
            this.src.unread(c);
        }
        int result = 0;
        switch (this.tokenBuffer.charAt(0)) {
            case '$': {
                this.lex_state = LexState.EXPR_END;
                result = 306;
                break;
            }
            case '@': {
                this.lex_state = LexState.EXPR_END;
                if (this.tokenBuffer.charAt(1) == '@') {
                    result = 309;
                    break;
                }
                result = 307;
                break;
            }
            default: {
                Keyword keyword;
                char last = this.tokenBuffer.charAt(this.tokenBuffer.length() - 1);
                if (last == '!' || last == '?') {
                    result = 305;
                } else {
                    if (this.lex_state == LexState.EXPR_FNAME) {
                        c = this.src.read();
                        if (c == '=') {
                            char c2 = this.src.read();
                            if (c2 != '~' && c2 != '>' && (c2 != '=' || c2 == '\n' && this.src.peek('>'))) {
                                result = 304;
                                this.tokenBuffer.append(c);
                                this.src.unread(c2);
                            } else {
                                this.src.unread(c2);
                                this.src.unread(c);
                            }
                        } else {
                            this.src.unread(c);
                        }
                    }
                    result = result == 0 && Character.isUpperCase(this.tokenBuffer.charAt(0)) ? 308 : 304;
                }
                if (this.lex_state != LexState.EXPR_DOT && (keyword = Keyword.getKeyword(this.tokenBuffer.toString(), this.tokenBuffer.length())) != null) {
                    LexState state = this.lex_state;
                    this.lex_state = keyword.state;
                    this.yaccValue = state.isExprFName() ? new Token(keyword.name, this.getPosition()) : new Token(this.tokenBuffer.toString(), this.getPosition());
                    if (keyword.id0 == 280) {
                        if (this.conditionState.isInState()) {
                            return 281;
                        }
                        if (this.cmdArgumentState.isInState() && state != LexState.EXPR_CMDARG) {
                            return 282;
                        }
                        if (state == LexState.EXPR_ENDARG) {
                            return 282;
                        }
                        return 280;
                    }
                    if (state == LexState.EXPR_BEG) {
                        return keyword.id0;
                    }
                    if (keyword.id0 != keyword.id1) {
                        this.lex_state = LexState.EXPR_BEG;
                    }
                    return keyword.id1;
                }
                if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_DOT || this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                    if (commandState) {
                        this.lex_state = LexState.EXPR_CMDARG;
                        break;
                    }
                    this.lex_state = LexState.EXPR_ARG;
                    break;
                }
                this.lex_state = LexState.EXPR_END;
            }
        }
        String tempVal = this.tokenBuffer.toString();
        StaticScope scope = this.parserSupport.getCurrentScope();
        if (IdUtil.getVarType(tempVal) == 8 && scope instanceof BlockStaticScope && scope.isDefined(tempVal) >= 0 || scope.getLocalScope().isDefined(tempVal) >= 0) {
            this.lex_state = LexState.EXPR_END;
        }
        this.yaccValue = new Token(tempVal, this.getPosition());
        return result;
    }

    private int parseNumber(char c) throws IOException {
        this.lex_state = LexState.EXPR_END;
        this.tokenBuffer.setLength(0);
        if (c == '-') {
            this.tokenBuffer.append(c);
            c = this.src.read();
        } else if (c == '+') {
            c = this.src.read();
        }
        char nondigit = '\u0000';
        if (c == '0') {
            int startLen = this.tokenBuffer.length();
            c = this.src.read();
            switch (c) {
                case 'X': 
                case 'x': {
                    c = this.src.read();
                    if (RubyYaccLexer.isHexChar(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!RubyYaccLexer.isHexChar(c)) break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Hexadecimal number without hex-digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 313;
                }
                case 'B': 
                case 'b': {
                    c = this.src.read();
                    if (c == '0' || c == '1') {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (c != '0' && c != '1') break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Binary number without digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 313;
                }
                case 'D': 
                case 'd': {
                    c = this.src.read();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Binary number without digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 313;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '_': {
                    while (true) {
                        if (c == '_') {
                            if (nondigit != '\u0000') break;
                            nondigit = c;
                        } else {
                            if (c < '0' || c > '7') break;
                            nondigit = '\u0000';
                            this.tokenBuffer.append(c);
                        }
                        c = this.src.read();
                    }
                    if (this.tokenBuffer.length() > startLen) {
                        this.src.unread(c);
                        if (nondigit != '\u0000') {
                            throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 313;
                    }
                }
                case '8': 
                case '9': {
                    throw new SyntaxException(this.getPosition(), "Illegal octal digit.");
                }
                case '.': 
                case 'E': 
                case 'e': {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.src.unread(c);
                    this.yaccValue = new FixnumNode(this.getPosition(), 0L);
                    return 313;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nondigit = '\u0000';
                    this.tokenBuffer.append(c);
                    break;
                }
                case '.': {
                    if (nondigit != '\u0000') {
                        this.src.unread(c);
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    if (seen_point || seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    char c2 = this.src.read();
                    if (!Character.isDigit(c2)) {
                        this.src.unread(c2);
                        this.src.unread('.');
                        if (c == '_') break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 313;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append(c2);
                    seen_point = true;
                    nondigit = '\u0000';
                    break;
                }
                case 'E': 
                case 'e': {
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    if (seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    this.tokenBuffer.append(c);
                    seen_e = true;
                    nondigit = c;
                    c = this.src.read();
                    if (c == '-' || c == '+') {
                        this.tokenBuffer.append(c);
                        nondigit = c;
                        break;
                    }
                    this.src.unread(c);
                    break;
                }
                case '_': {
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.src.unread(c);
                    return this.getNumberToken(this.tokenBuffer.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.src.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, char nondigit) {
        if (nondigit != '\u0000') {
            throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
        }
        if (isFloat) {
            double d;
            try {
                d = Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                this.warnings.warn(this.getPosition(), "Float " + number + " out of range.");
                d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            this.yaccValue = new FloatNode(this.getPosition(), d);
            return 314;
        }
        this.yaccValue = this.getInteger(number, 10);
        return 313;
    }
}

