/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleSet;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class IndexSelector {
    IDLTKSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;
    IPath[] containerPaths;
    private boolean mixinOnly = false;

    public IndexSelector(IDLTKSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IModelElement focus, boolean isPolymorphicSearch, IPath projectOrArchivePath) {
        try {
            IScriptModel model;
            IScriptProject project;
            IBuildpathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                ScriptProject focusProject = focus instanceof ArchiveProjectFragment ? (ScriptProject)focus.getParent() : (ScriptProject)focus;
                focusEntries = focusProject.getExpandedBuildpath();
            }
            if ((project = IndexSelector.getScriptProject(projectOrArchivePath, model = focus.getModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (ScriptProject)project, focusEntries);
            }
            IScriptProject[] allProjects = model.getScriptProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                ScriptProject otherProject = (ScriptProject)allProjects[i];
                IBuildpathEntry entry = otherProject.getBuildpathEntryFor(projectOrArchivePath);
                if (entry != null && entry.getEntryKind() == 1 && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IModelElement focus, ScriptProject scriptProject, IBuildpathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            int i;
            IPath focusPath;
            if (focus.equals(scriptProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = scriptProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IBuildpathEntry entry = focusEntriesForPolymorphicSearch[i2];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof ArchiveProjectFragment) {
                focusPath = focus.getPath();
                IBuildpathEntry[] entries = scriptProject.getExpandedBuildpath();
                i = 0;
                int length = entries.length;
                while (i < length) {
                    IBuildpathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            focusPath = ((ScriptProject)focus).getProject().getFullPath();
            IBuildpathEntry[] entries = scriptProject.getExpandedBuildpath();
            i = 0;
            int length = entries.length;
            while (i < length) {
                IBuildpathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    private void initializeIndexLocations() {
        IPath[] projectsAndArchives = this.searchScope.enclosingProjectsAndZips();
        IndexManager manager = ModelManager.getModelManager().getIndexManager();
        SimpleSet locations = new SimpleSet();
        IModelElement focus = MatchLocator.projectOrArchiveFocus(this.pattern);
        boolean mix = this.mixinOnly;
        Model model = ModelManager.getModelManager().getModel();
        if (focus == null) {
            int i = 0;
            while (i < projectsAndArchives.length) {
                if (!mix) {
                    locations.add(manager.computeIndexLocation(projectsAndArchives[i]));
                }
                this.checkSpecial(projectsAndArchives[i], manager, locations, model);
                ++i;
            }
        } else {
            try {
                int length = projectsAndArchives.length;
                ScriptProject[] projectsCanSeeFocus = new ScriptProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet archivesToCheck = new SimpleSet(length);
                IBuildpathEntry[] focusEntries = null;
                if (this.pattern != null && MatchLocator.isPolymorphicSearch(this.pattern)) {
                    ScriptProject focusProject = focus instanceof ArchiveProjectFragment ? (ScriptProject)focus.getParent() : (ScriptProject)focus;
                    focusEntries = focusProject.getExpandedBuildpath();
                }
                int i = 0;
                while (i < length) {
                    IPath path = projectsAndArchives[i];
                    ScriptProject project = (ScriptProject)IndexSelector.getScriptProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            if (!mix) {
                                locations.add(manager.computeIndexLocation(path));
                            }
                            this.checkSpecial(path, manager, locations, model);
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        archivesToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && archivesToCheck.elementSize > 0) {
                    IBuildpathEntry[] entries = projectsCanSeeFocus[i].getResolvedBuildpath();
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        IBuildpathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || !archivesToCheck.includes(path = entry.getPath())) continue;
                        if (!mix) {
                            locations.add(manager.computeIndexLocation(entry.getPath()));
                        }
                        archivesToCheck.remove(path);
                    }
                    ++i;
                }
                if (archivesToCheck.elementSize > 0) {
                    IScriptProject[] allProjects = model.getScriptProjects();
                    int i2 = 0;
                    int l = allProjects.length;
                    while (i2 < l && archivesToCheck.elementSize > 0) {
                        ScriptProject project = (ScriptProject)allProjects[i2];
                        if (!visitedProjects.includes(project)) {
                            IBuildpathEntry[] entries = project.getResolvedBuildpath();
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                IBuildpathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || !archivesToCheck.includes(path = entry.getPath())) continue;
                                if (!mix) {
                                    locations.add(manager.computeIndexLocation(entry.getPath()));
                                }
                                archivesToCheck.remove(path);
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (ModelException modelException) {}
        }
        this.indexLocations = new IPath[locations.elementSize];
        Object[] values = locations.values;
        int count = 0;
        int i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = new Path((String)values[i]);
        }
    }

    private void checkSpecial(IPath projectsAndArchives, IndexManager manager, SimpleSet locations, IScriptModel model) {
        String prjPath = "#special#mixin#" + projectsAndArchives.toString();
        locations.add(manager.computeIndexLocation((IPath)new Path(prjPath)));
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IScriptProject getScriptProject(IPath path, IScriptModel model) {
        IScriptProject project = model.getScriptProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public void setMixinOnly(boolean bOnlyMixin) {
        this.mixinOnly = bOnlyMixin;
    }
}

