/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.ui.dialogs.ListDialog;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReorgQueries
implements IReorgQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public ReorgQueries(Wizard wizard) {
        Assert.isNotNull((Object)wizard);
        this.fWizard = wizard;
        this.fShell = null;
    }

    public ReorgQueries(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.fWizard = null;
        this.fShell = shell;
    }

    private Shell getShell() {
        Assert.isTrue((this.fShell == null || this.fWizard == null ? 1 : 0) != 0);
        Assert.isTrue((this.fShell != null || this.fWizard != null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        return this.fShell;
    }

    @Override
    public IConfirmQuery createYesYesToAllNoNoToAllQuery(String dialogTitle, boolean allowCancel, int queryID) {
        return new YesYesToAllNoNoToAllQuery(this.getShell(), allowCancel, dialogTitle);
    }

    @Override
    public IConfirmQuery createYesNoQuery(String dialogTitle, boolean allowCancel, int queryID) {
        return new YesNoQuery(this.getShell(), allowCancel, dialogTitle);
    }

    @Override
    public IConfirmQuery createSkipQuery(String dialogTitle, int queryID) {
        return new SkipQuery(this.getShell(), dialogTitle);
    }

    private static class SkipQuery
    implements IConfirmQuery {
        private final Shell fShell;
        private final String fDialogTitle;
        private boolean fSkipAll;

        SkipQuery(Shell parent, String dialogTitle) {
            this.fShell = parent;
            this.fDialogTitle = dialogTitle;
            this.fSkipAll = false;
        }

        @Override
        public boolean confirm(String question) throws OperationCanceledException {
            if (this.fSkipAll) {
                return false;
            }
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, result));
            return this.getResult(result);
        }

        @Override
        public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
            throw new UnsupportedOperationException("Not supported for skip queries");
        }

        private Runnable createQueryRunnable(final String question, final int[] result) {
            return new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(SkipQuery.this.fShell, SkipQuery.this.fDialogTitle, null, question, 3, this.getButtonLabels(), 0);
                    dialog.open();
                    switch (dialog.getReturnCode()) {
                        case -1: {
                            result[0] = 1;
                            break;
                        }
                        default: {
                            result[0] = dialog.getReturnCode();
                        }
                    }
                }

                private String[] getButtonLabels() {
                    return new String[]{IDialogConstants.SKIP_LABEL, ReorgMessages.ReorgQueries_skip_all, IDialogConstants.CANCEL_LABEL};
                }
            };
        }

        private boolean getResult(int[] result) throws OperationCanceledException {
            switch (result[0]) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.fSkipAll = true;
                    return false;
                }
                case 2: {
                    throw new OperationCanceledException();
                }
            }
            return false;
        }
    }

    private static final class YesNoListDialog
    extends ListDialog {
        private final boolean fYesToAllNoToAll;

        private YesNoListDialog(Shell parent, boolean includeYesToAllNoToAll) {
            super(parent, 67632);
            this.fYesToAllNoToAll = includeYesToAllNoToAll;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            this.setReturnCode(buttonId);
            this.close();
        }

        @Override
        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            if (this.fYesToAllNoToAll) {
                this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            }
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            if (this.fYesToAllNoToAll) {
                this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            }
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private static class YesNoQuery
    implements IConfirmQuery {
        private final Shell fShell;
        private final String fDialogTitle;
        private final boolean fAllowCancel;

        YesNoQuery(Shell parent, boolean allowCancel, String dialogTitle) {
            this.fShell = parent;
            this.fDialogTitle = dialogTitle;
            this.fAllowCancel = allowCancel;
        }

        @Override
        public boolean confirm(String question) throws OperationCanceledException {
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, result));
            return this.getResult(result);
        }

        @Override
        public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, elements, result));
            return this.getResult(result);
        }

        private Runnable createQueryRunnable(final String question, final int[] result) {
            return new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(YesNoQuery.this.fShell, YesNoQuery.this.fDialogTitle, null, question, 3, this.getButtonLabels(), 0);
                    dialog.open();
                    switch (dialog.getReturnCode()) {
                        case -1: {
                            result[0] = YesNoQuery.this.fAllowCancel ? 1 : 3;
                            break;
                        }
                        case 0: {
                            result[0] = 2;
                            break;
                        }
                        case 1: {
                            result[0] = 3;
                            break;
                        }
                        case 2: {
                            if (YesNoQuery.this.fAllowCancel) {
                                result[0] = 1;
                                break;
                            }
                            Assert.isTrue((boolean)false);
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                        }
                    }
                }

                private String[] getButtonLabels() {
                    if (YesNoQuery.this.fAllowCancel) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                }
            };
        }

        private Runnable createQueryRunnable(final String question, final Object[] elements, final int[] result) {
            return new Runnable(){

                @Override
                public void run() {
                    YesNoListDialog dialog = new YesNoListDialog(YesNoQuery.this.fShell, false);
                    dialog.setAddCancelButton(false);
                    dialog.setBlockOnOpen(true);
                    dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dialog.setLabelProvider((ILabelProvider)new ModelElementLabelProvider());
                    dialog.setTitle(YesNoQuery.this.fDialogTitle);
                    dialog.setMessage(question);
                    dialog.setInput(elements);
                    dialog.open();
                    result[0] = dialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] result) throws OperationCanceledException {
            switch (result[0]) {
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }
    }

    private static class YesYesToAllNoNoToAllQuery
    implements IConfirmQuery {
        private final boolean fAllowCancel;
        private boolean fYesToAll = false;
        private boolean fNoToAll = false;
        private final Shell fShell;
        private final String fDialogTitle;

        YesYesToAllNoNoToAllQuery(Shell parent, boolean allowCancel, String dialogTitle) {
            this.fShell = parent;
            this.fDialogTitle = dialogTitle;
            this.fAllowCancel = allowCancel;
        }

        @Override
        public boolean confirm(String question) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, result));
            return this.getResult(result);
        }

        @Override
        public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
            if (this.fYesToAll) {
                return true;
            }
            if (this.fNoToAll) {
                return false;
            }
            int[] result = new int[1];
            this.fShell.getDisplay().syncExec(this.createQueryRunnable(question, elements, result));
            return this.getResult(result);
        }

        private Runnable createQueryRunnable(final String question, final int[] result) {
            return new Runnable(){

                @Override
                public void run() {
                    int[] resultId = this.getResultIDs();
                    MessageDialog dialog = new MessageDialog(YesYesToAllNoNoToAllQuery.this.fShell, YesYesToAllNoNoToAllQuery.this.fDialogTitle, null, question, 3, this.getButtonLabels(), 0);
                    dialog.open();
                    result[0] = dialog.getReturnCode() == -1 ? (YesYesToAllNoNoToAllQuery.this.fAllowCancel ? 1 : 3) : resultId[dialog.getReturnCode()];
                }

                private String[] getButtonLabels() {
                    if (YesYesToAllNoNoToAllQuery.this.fAllowCancel) {
                        return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                    return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
                }

                private int[] getResultIDs() {
                    if (YesYesToAllNoNoToAllQuery.this.fAllowCancel) {
                        return new int[]{2, 4, 3, 21, 1};
                    }
                    return new int[]{2, 4, 3, 21};
                }
            };
        }

        private Runnable createQueryRunnable(final String question, final Object[] elements, final int[] result) {
            return new Runnable(){

                @Override
                public void run() {
                    YesNoListDialog dialog = new YesNoListDialog(YesYesToAllNoNoToAllQuery.this.fShell, true);
                    dialog.setAddCancelButton(false);
                    dialog.setBlockOnOpen(true);
                    dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                    dialog.setLabelProvider((ILabelProvider)new ModelElementLabelProvider());
                    dialog.setTitle(YesYesToAllNoNoToAllQuery.this.fDialogTitle);
                    dialog.setMessage(question);
                    dialog.setInput(elements);
                    dialog.open();
                    result[0] = dialog.getReturnCode();
                }
            };
        }

        private boolean getResult(int[] result) throws OperationCanceledException {
            switch (result[0]) {
                case 4: {
                    this.fYesToAll = true;
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    return false;
                }
                case 21: {
                    this.fNoToAll = true;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }
    }
}

