/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public class MonitoringNewNameQueries
implements INewNameQueries {
    private INewNameQueries fDelegate;
    private ReorgExecutionLog fExecutionLog;

    public MonitoringNewNameQueries(INewNameQueries delegate, ReorgExecutionLog log) {
        this.fDelegate = delegate;
        this.fExecutionLog = log;
    }

    @Override
    public INewNameQuery createNewSourceModuleNameQuery(ISourceModule cu, String initialSuggestedName) {
        return () -> {
            String result = this.fDelegate.createNewSourceModuleNameQuery(cu, initialSuggestedName).getNewName();
            String newName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)result);
            this.fExecutionLog.setNewName((Object)cu, newName);
            ResourceMapping mapping = DLTKElementResourceMapping.create(cu);
            if (mapping != null) {
                this.fExecutionLog.setNewName((Object)mapping, newName);
            }
            return result;
        };
    }

    @Override
    public INewNameQuery createNewProjectFragmentNameQuery(IProjectFragment root, String initialSuggestedName) {
        return () -> {
            String result = this.fDelegate.createNewProjectFragmentNameQuery(root, initialSuggestedName).getNewName();
            this.fExecutionLog.setNewName((Object)root, result);
            ResourceMapping mapping = DLTKElementResourceMapping.create(root);
            if (mapping != null) {
                this.fExecutionLog.setNewName((Object)mapping, result);
            }
            return result;
        };
    }

    @Override
    public INewNameQuery createNewPackageNameQuery(IScriptFolder pack, String initialSuggestedName) {
        return () -> {
            String result = this.fDelegate.createNewPackageNameQuery(pack, initialSuggestedName).getNewName();
            this.fExecutionLog.setNewName((Object)pack, result);
            ResourceMapping mapping = DLTKElementResourceMapping.create(pack);
            if (mapping != null) {
                int index = result.lastIndexOf(46);
                String newFolderName = index == -1 ? result : result.substring(index + 1);
                this.fExecutionLog.setNewName((Object)mapping, newFolderName);
            }
            return result;
        };
    }

    @Override
    public INewNameQuery createNewResourceNameQuery(IResource res, String initialSuggestedName) {
        return () -> {
            String result = this.fDelegate.createNewResourceNameQuery(res, initialSuggestedName).getNewName();
            this.fExecutionLog.setNewName((Object)res, result);
            return result;
        };
    }

    @Override
    public INewNameQuery createNullQuery() {
        return this.fDelegate.createNullQuery();
    }

    @Override
    public INewNameQuery createStaticQuery(String newName) {
        return this.fDelegate.createStaticQuery(newName);
    }
}

