/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.logconsole.ui;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.logconsole.CompoundMessage;
import org.eclipse.dltk.logconsole.ILogCategory;
import org.eclipse.dltk.logconsole.ILogConsoleStream;
import org.eclipse.dltk.logconsole.LogConsoleType;
import org.eclipse.dltk.logconsole.impl.AbstractLogConsole;
import org.eclipse.dltk.logconsole.ui.LogConsoleImpl;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class DefaultLogConsole
extends AbstractLogConsole {
    protected final List<LogItem> items = new ArrayList<LogItem>();
    protected int writePos = 0;
    private static final int LIMIT = 1000;
    private static final int PURGE = 250;
    private final Job writeJob = new Job(""){
        private final StringBuilder buffer;
        private final Timestamp timestamp;
        {
            this.buffer = new StringBuilder(128);
            this.timestamp = new Timestamp(System.currentTimeMillis());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() throws IOException {
            List<LogItem> list = DefaultLogConsole.this.items;
            synchronized (list) {
                if (DefaultLogConsole.this.consoleImpl == null) {
                    return;
                }
                if (DefaultLogConsole.this.writePos < DefaultLogConsole.this.items.size()) {
                    int i = DefaultLogConsole.this.writePos;
                    while (i < DefaultLogConsole.this.items.size()) {
                        LogItem item = DefaultLogConsole.this.items.get(i);
                        this.buffer.setLength(0);
                        if (item.timestamp != 0L) {
                            this.timestamp.setTime(item.timestamp);
                            String timeStr = this.timestamp.toString();
                            this.buffer.append(timeStr.substring(11));
                            if (timeStr.length() < 23) {
                                this.buffer.append("000".substring(0, 23 - timeStr.length()));
                            }
                            this.buffer.append(' ');
                        }
                        if (item.category != null) {
                            this.buffer.append(item.category);
                            this.buffer.append(' ');
                        }
                        if (item.message instanceof CompoundMessage) {
                            CompoundMessage msg = (CompoundMessage)item.message;
                            int headerLen = this.buffer.length();
                            this.buffer.append(msg.getHeader());
                            DefaultLogConsole.this.consoleImpl.println(item.stream, this.buffer.toString());
                            if (!msg.getContents().isEmpty()) {
                                this.buffer.setLength(headerLen += 2);
                                int j = 0;
                                while (j < headerLen) {
                                    this.buffer.setCharAt(j, ' ');
                                    ++j;
                                }
                                for (Object message : msg.getContents()) {
                                    this.buffer.append(message);
                                    DefaultLogConsole.this.consoleImpl.println(item.stream, this.buffer.toString());
                                    this.buffer.setLength(headerLen);
                                }
                            }
                        } else {
                            this.buffer.append(item.message);
                            DefaultLogConsole.this.consoleImpl.println(item.stream, this.buffer.toString());
                        }
                        ++i;
                    }
                    DefaultLogConsole.this.writePos = DefaultLogConsole.this.items.size();
                }
            }
        }
    };
    protected LogConsoleImpl consoleImpl = null;

    public DefaultLogConsole(LogConsoleType consoleType, Object identifier) {
        super(consoleType, identifier);
    }

    public void println(ILogConsoleStream stream, Object message) {
        if (message == null) {
            return;
        }
        this.print(new LogItem(stream, System.currentTimeMillis(), null, message));
    }

    public void println(ILogCategory category, Object message) {
        if (message == null) {
            return;
        }
        this.print(new LogItem(category.stream(), System.currentTimeMillis(), category, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(LogItem item) {
        List<LogItem> list = this.items;
        synchronized (list) {
            this.items.add(item);
            if (this.items.size() > 1000) {
                this.items.removeAll(new ArrayList<LogItem>(this.items.subList(0, 250)));
                this.writePos = this.writePos > 250 ? (this.writePos -= 250) : 0;
            }
            if (this.consoleImpl != null) {
                this.writeJob.schedule(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        List<LogItem> list = this.items;
        synchronized (list) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            if (this.consoleImpl == null) {
                this.consoleImpl = new LogConsoleImpl(this);
                consoleManager.addConsoles(new IConsole[]{this.consoleImpl});
            }
            consoleManager.showConsoleView((IConsole)this.consoleImpl);
        }
    }

    protected void consoleInitialized() {
        this.writeJob.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consoleDisposed() {
        List<LogItem> list = this.items;
        synchronized (list) {
            this.consoleImpl = null;
            this.writePos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        List<LogItem> list = this.items;
        synchronized (list) {
            this.items.clear();
            this.writePos = 0;
        }
    }

    private static class LogItem {
        final ILogConsoleStream stream;
        final long timestamp;
        final ILogCategory category;
        final Object message;

        public LogItem(ILogConsoleStream stream, long timestamp, ILogCategory category, Object message) {
            this.stream = stream;
            this.timestamp = timestamp;
            this.category = category;
            this.message = message;
        }
    }
}

