/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.editor;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.editor.TclBracketInserter;
import org.eclipse.dltk.tcl.internal.ui.editor.TclDocumentSetupParticipant;
import org.eclipse.dltk.tcl.internal.ui.editor.TclOutlinePage;
import org.eclipse.dltk.tcl.internal.ui.text.TclPairMatcher;
import org.eclipse.dltk.tcl.internal.ui.text.folding.TclFoldingStructureProvider;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;

public class TclEditor
extends ScriptEditor {
    public static final String EDITOR_ID = "org.eclipse.dltk.tcl.ui.editor.TclEditor";
    public static final String EDITOR_CONTEXT = "#TclEditorContext";
    public static final String RULER_CONTEXT = "#TclRulerContext";
    private BracketInserter fBracketInserter = new TclBracketInserter(this);
    private IFoldingStructureProvider foldingProvider;
    static final String[] properties = new String[]{"editor_folding_blocks", "editor_folding_exclude_list", "editor_folding_include_list"};

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected String[] getFoldingEventPreferenceKeys() {
        return properties;
    }

    public IPreferenceStore getScriptPreferenceStore() {
        return TclUI.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return TclUI.getDefault().getTextTools();
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new TclOutlinePage(this, TclUI.getDefault().getPreferenceStore());
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 doc;
        if (document instanceof IDocumentExtension3 && (doc = (IDocumentExtension3)document).getDocumentPartitioner("__tcl_partitioning") == null) {
            TclDocumentSetupParticipant participant = new TclDocumentSetupParticipant();
            participant.setup(document);
        }
    }

    protected IFoldingStructureProvider createFoldingStructureProvider() {
        if (this.foldingProvider == null) {
            this.foldingProvider = new TclFoldingStructureProvider();
        }
        return this.foldingProvider;
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.dltk.ui.tclEditorScope"});
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return TclLanguageToolkit.getDefault();
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }

    protected ICharacterPairMatcher createBracketMatcher() {
        return new TclPairMatcher();
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        super.dispose();
    }
}

