/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;

public abstract class InternalSearchPattern {
    public IModelElement focus;
    public int kind;

    public void acceptMatch(String relativePath, String containerPath, char separator, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope) {
        String documentPath;
        String documentPath2;
        DLTKSearchScope javaSearchScope;
        AccessRuleSet access;
        if (scope instanceof DLTKSearchScope ? (access = (javaSearchScope = (DLTKSearchScope)scope).getAccessRuleSet(relativePath, containerPath)) != DLTKSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath2 = this.documentPath(containerPath, separator, relativePath), pattern, participant, access) : scope.encloses(documentPath = this.documentPath(containerPath, separator, relativePath)) && !requestor.acceptIndexMatch(documentPath, pattern, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    public SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    public String documentPath(String containerPath, char separator, String relativePath) {
        StringBuilder buffer = new StringBuilder(containerPath.length() + 1 + relativePath.length());
        buffer.append(containerPath);
        buffer.append(separator);
        buffer.append(relativePath);
        return buffer.toString();
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope, IProgressMonitor monitor) throws IOException {
        if (participant.isSkipped(index)) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            SearchPattern decodedResult = pattern.getBlankPattern();
            String containerPath = index.getContainerPath();
            char separator = index.separator;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    String[] names = entry.getDocumentNames(index);
                    int j = 0;
                    int n = names.length;
                    while (j < n) {
                        this.acceptMatch(names[j], containerPath, separator, decodedResult, requestor, participant, scope);
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    public boolean isPolymorphicSearch() {
        return false;
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

