/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.resources.evProcessor;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.state.StateStrings;
import org.eclipse.linuxtools.lttng.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.state.model.LTTngCPUState;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventResource;
import org.eclipse.linuxtools.lttng.ui.views.resources.evProcessor.AbsResourcesTRangeUpdate;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;

public class ResourcesBeforeUpdateHandlers {
    final ILttngEventProcessor getBeforeSchedChangeHandler() {
        AbsResourcesTRangeUpdate handler = new AbsResourcesTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                this.globalProcessBeforeExecmode(trcEvent, traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBeforeExecutionModeIrq() {
        AbsResourcesTRangeUpdate handler = new AbsResourcesTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long irqId = null;
                if (trcEvent.getChannelName().equals(StateStrings.Channels.LTT_CHANNEL_KERNEL)) {
                    return false;
                }
                if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_IRQ_ENTRY.getInName())) {
                    irqId = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_IRQ_ID);
                } else if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_IRQ_EXIT.getInName())) {
                    long cpu = trcEvent.getCpuId();
                    irqId = ((LTTngCPUState)traceSt.getCpu_states().get(cpu)).peekFromIrqStack();
                    if (irqId.equals(-1L)) {
                        return false;
                    }
                }
                TimeRangeEventResource localResource = this.resourcelist_obtain_irq(traceSt, irqId);
                if (localResource == null) {
                    TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                    localResource = this.addLocalResource(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId(), TimeRangeEventResource.ResourceTypes.IRQ, irqId, trcEvent.getTimestamp().getValue());
                }
                long stime = localResource.getNext_good_time();
                String irqStateMode = localResource.getStateMode(traceSt);
                this.makeDraw(traceSt, stime, trcEvent.getTimestamp().getValue(), localResource, this.params, irqStateMode);
                this.globalProcessBeforeExecmode(trcEvent, traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBeforeExecutionModeSoftIrq() {
        AbsResourcesTRangeUpdate handler = new AbsResourcesTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long softIrqId = null;
                if (trcEvent.getChannelName().equals(StateStrings.Channels.LTT_CHANNEL_KERNEL)) {
                    return false;
                }
                if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_SOFT_IRQ_RAISE.getInName()) || trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_SOFT_IRQ_ENTRY.getInName())) {
                    softIrqId = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_SOFT_IRQ_ID);
                } else if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_SOFT_IRQ_EXIT.getInName())) {
                    long cpu = trcEvent.getCpuId();
                    softIrqId = ((LTTngCPUState)traceSt.getCpu_states().get(cpu)).peekFromSoftIrqStack();
                    if (softIrqId < 0L) {
                        return false;
                    }
                }
                TimeRangeEventResource localResource = this.resourcelist_obtain_soft_irq(traceSt, softIrqId);
                if (localResource == null) {
                    TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                    localResource = this.addLocalResource(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId(), TimeRangeEventResource.ResourceTypes.SOFT_IRQ, softIrqId, trcEvent.getTimestamp().getValue());
                }
                long stime = localResource.getNext_good_time();
                String softIrqStateMode = localResource.getStateMode(traceSt);
                this.makeDraw(traceSt, stime, trcEvent.getTimestamp().getValue(), localResource, this.params, softIrqStateMode);
                this.globalProcessBeforeExecmode(trcEvent, traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBeforeExecutionModeTrap() {
        AbsResourcesTRangeUpdate handler = new AbsResourcesTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long trapId = null;
                if (trcEvent.getChannelName().equals(StateStrings.Channels.LTT_CHANNEL_KERNEL)) {
                    return false;
                }
                if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_TRAP_ENTRY.getInName()) || trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_PAGE_FAULT_ENTRY.getInName()) || trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_PAGE_FAULT_NOSEM_ENTRY.getInName())) {
                    trapId = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_TRAP_ID);
                } else if (trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_TRAP_EXIT.getInName()) || trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_PAGE_FAULT_EXIT.getInName()) || trcEvent.getMarkerName().equals(StateStrings.Events.LTT_EVENT_PAGE_FAULT_NOSEM_EXIT.getInName())) {
                    long cpu = trcEvent.getCpuId();
                    trapId = ((LTTngCPUState)traceSt.getCpu_states().get(cpu)).peekFromTrapStack();
                    if (trapId.equals(-1L)) {
                        return false;
                    }
                } else {
                    return false;
                }
                TimeRangeEventResource localResource = this.resourcelist_obtain_trap(traceSt, trapId);
                if (localResource == null) {
                    TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                    localResource = this.addLocalResource(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId(), TimeRangeEventResource.ResourceTypes.TRAP, trapId, trcEvent.getTimestamp().getValue());
                }
                String trapStateMode = localResource.getStateMode(traceSt);
                long stime = localResource.getNext_good_time();
                this.makeDraw(traceSt, stime, trcEvent.getTimestamp().getValue(), localResource, this.params, trapStateMode);
                this.globalProcessBeforeExecmode(trcEvent, traceSt);
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBeforeBdevEvent() {
        AbsResourcesTRangeUpdate handler = new AbsResourcesTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long major = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MAJOR);
                Long minor = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_MINOR);
                Long bdevId = this.getMkdevId(major, minor);
                TimeRangeEventResource localResource = this.resourcelist_obtain_bdev(traceSt, bdevId);
                if (localResource == null) {
                    TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                    localResource = this.addLocalResource(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId(), TimeRangeEventResource.ResourceTypes.BDEV, bdevId, trcEvent.getTimestamp().getValue());
                }
                long stime = localResource.getNext_good_time();
                String bdevStateMode = localResource.getStateMode(traceSt);
                this.makeDraw(traceSt, stime, trcEvent.getTimestamp().getValue(), localResource, this.params, bdevStateMode);
                return false;
            }
        };
        return handler;
    }
}

