/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.ui.Messages;

public class SRPMImportOperation
implements IRunnableWithProgress {
    private IProject project;
    private File sourceRPM;
    private IProgressMonitor monitor;
    private List<Exception> rpm_errorTable;

    public SRPMImportOperation(IProject project, File sourceRPM) {
        this.project = project;
        this.sourceRPM = sourceRPM;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
        int totalWork = 2;
        this.monitor = progressMonitor;
        this.rpm_errorTable = new ArrayList<Exception>();
        this.monitor.beginTask(Messages.getString("SRPMImportOperation.Starting"), totalWork);
        try {
            RPMProject rpmProject = new RPMProject(this.project);
            this.monitor.worked(1);
            this.monitor.setTaskName(Messages.getString("SRPMImportOperation.Importing_SRPM"));
            rpmProject.importSourceRPM(this.sourceRPM);
        }
        catch (Exception e) {
            this.rpm_errorTable.add(e);
            return;
        }
        this.monitor.worked(1);
    }

    public MultiStatus getStatus() {
        IStatus[] errors = new IStatus[this.rpm_errorTable.size()];
        Iterator<Exception> count = this.rpm_errorTable.iterator();
        int iCount = 0;
        String error_message = Messages.getString("SRPMImportOperation.0");
        while (count.hasNext()) {
            Throwable errorObject;
            Exception anonErrorObject = count.next();
            if (anonErrorObject instanceof Throwable) {
                errorObject = anonErrorObject;
                error_message = errorObject.getMessage();
                if (error_message == null) {
                    error_message = Messages.getString("SRPMImportOperation.1");
                }
            } else if (anonErrorObject instanceof Status && (error_message = (errorObject = (Status)anonErrorObject).getMessage()) == null) {
                error_message = Messages.getString("SRPMImportOperation.2");
            }
            Status error = new Status(4, "RPM Plugin", 0, error_message, null);
            errors[iCount] = error;
            ++iCount;
        }
        return new MultiStatus("org.eclipse.ui", 0, errors, Messages.getString("SRPMImportOperation.3"), null);
    }
}

