/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    final int BUF_SIZE;
    byte[] buffer;
    int buf_end = 0;
    int buf_pos = 0;
    long real_pos = 0L;
    StringBuilder sb = new StringBuilder();

    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(name, mode, 8192);
    }

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        this(file, mode, 8192);
    }

    public BufferedRandomAccessFile(String name, String mode, int bufsize) throws IOException {
        super(name, mode);
        this.invalidate();
        this.BUF_SIZE = bufsize;
        this.buffer = new byte[this.BUF_SIZE];
    }

    public BufferedRandomAccessFile(File file, String mode, int bufsize) throws IOException {
        super(file, mode);
        this.invalidate();
        this.BUF_SIZE = bufsize;
        this.buffer = new byte[this.BUF_SIZE];
    }

    @Override
    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.buf_end - this.buf_pos;
        if (len <= leftover) {
            System.arraycopy(this.buffer, this.buf_pos, b, off, len);
            this.buf_pos += len;
            return len;
        }
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
            ++i;
        }
        return len;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.real_pos - pos);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        String str = null;
        if (this.buf_end - this.buf_pos <= 0 && this.fillBuffer() < 0) {
            return null;
        }
        int lineend = -1;
        int i = this.buf_pos;
        while (i < this.buf_end) {
            if (this.buffer[i] == 10) {
                lineend = i;
                break;
            }
            ++i;
        }
        if (lineend < 0) {
            int c;
            this.sb.delete(0, this.sb.length());
            while ((c = this.read()) != -1 && c != 10) {
                this.sb.append((char)c);
            }
            if (c == -1 && this.sb.length() == 0) {
                return null;
            }
            if (this.sb.charAt(this.sb.length() - 1) == '\r') {
                this.sb.deleteCharAt(this.sb.length() - 1);
            }
            return this.sb.toString();
        }
        str = lineend > 0 && this.buffer[lineend - 1] == 13 && lineend > this.buf_pos ? new String(this.buffer, this.buf_pos, lineend - this.buf_pos - 1, CHARSET_UTF8) : new String(this.buffer, this.buf_pos, lineend - this.buf_pos, CHARSET_UTF8);
        this.buf_pos = lineend + 1;
        return str;
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUF_SIZE);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = super.getFilePointer();
    }
}

