/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.core.ValgrindParserUtils;

public class ValgrindCoreParser {
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String AT = "at";
    private static final String BY = "by";
    protected List<IValgrindMessage> messages;
    protected int pid;
    protected ILaunch launch;

    public ValgrindCoreParser(File inputFile, ILaunch launch) throws IOException {
        this.launch = launch;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        Stack<IValgrindMessage> messageStack = new Stack<IValgrindMessage>();
        Stack<Integer> indentStack = new Stack<Integer>();
        this.messages = new ArrayList<IValgrindMessage>();
        try {
            String line;
            this.pid = ValgrindParserUtils.parsePID(inputFile.getName(), "valgrind_");
            while ((line = br.readLine()) != null) {
                line = line.replaceFirst("==\\d+==|\\*\\*\\d+\\*\\*", EMPTY_STRING);
                int indent = 0;
                while (indent < line.length() && line.charAt(indent) == ' ') {
                    ++indent;
                }
                if ((line = line.trim()).equals(EMPTY_STRING)) continue;
                if (indent == 1) {
                    IValgrindMessage message = this.getMessage(null, line);
                    this.messages.add(message);
                    messageStack.clear();
                    messageStack.push(message);
                    indentStack.clear();
                    indentStack.push(indent);
                    continue;
                }
                if (indent <= 1) continue;
                while (indent <= (Integer)indentStack.peek()) {
                    messageStack.pop();
                    indentStack.pop();
                }
                messageStack.push(this.getMessage((IValgrindMessage)messageStack.peek(), line));
                indentStack.push(indent);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    protected IValgrindMessage getMessage(IValgrindMessage message, String line) throws IOException {
        if (line.startsWith(AT) || line.startsWith(BY)) {
            Object[] parsed = ValgrindParserUtils.parseFilename(line);
            String filename = (String)parsed[0];
            int lineNo = (Integer)parsed[1];
            return new ValgrindStackFrame(message, line, this.launch, filename, lineNo);
        }
        return new ValgrindError(message, line, this.launch, this.pid);
    }

    public IValgrindMessage[] getMessages() {
        return this.messages.toArray(new IValgrindMessage[this.messages.size()]);
    }

    public void printMessages(IValgrindMessage m, int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print(SPACE);
            ++i;
        }
        System.out.println(m.getText());
        IValgrindMessage[] iValgrindMessageArray = m.getChildren();
        int n = iValgrindMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IValgrindMessage child = iValgrindMessageArray[n2];
            this.printMessages(child, indent + 1);
            ++n2;
        }
    }
}

