/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.binutils.Activator;
import org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditorInput;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class STLink2SourceSupport {
    public static final STLink2SourceSupport sharedInstance = new STLink2SourceSupport();

    protected STLink2SourceSupport() {
    }

    public boolean openSourceFileAtSymbol(IBinaryParser.ISymbol symbol) {
        if (symbol == null) {
            return false;
        }
        return this.openSourceFileAtSymbol(symbol.getBinaryObject(), symbol);
    }

    public boolean openSourceFileAtLocation(String binaryLoc, String addr2lineOutput) throws IOException {
        if (binaryLoc == null) {
            return false;
        }
        return this.openSourceFileAtLocation((IPath)new Path(binaryLoc), addr2lineOutput);
    }

    public boolean openSourceFileAtLocation(String binaryLoc, String sourceLoc, String lineNumber) throws IOException {
        if (binaryLoc == null) {
            return false;
        }
        return this.openSourceFileAtLocation((IPath)new Path(binaryLoc), sourceLoc, lineNumber);
    }

    public boolean openSourceFileAtLocation(String binaryLoc, String sourceLoc, int lineNumber) throws IOException {
        if (binaryLoc == null) {
            return false;
        }
        return this.openSourceFileAtLocation((IPath)new Path(binaryLoc), sourceLoc, lineNumber);
    }

    public boolean openSourceFileAtAddress(String binaryLoc, long address) throws IOException {
        if (binaryLoc == null) {
            return false;
        }
        return this.openSourceFileAtAddress((IPath)new Path(binaryLoc), address);
    }

    public boolean openSourceFileAtAddress(String binaryLoc, String address) throws IOException {
        if (binaryLoc == null) {
            return false;
        }
        return this.openSourceFileAtAddress((IPath)new Path(binaryLoc), address);
    }

    public boolean openSourceFileAtLocation(IPath binaryLoc, String addr2lineOutput) throws IOException {
        String filename = this.getFileName(addr2lineOutput);
        int lineNumber = this.getLineNumber(addr2lineOutput);
        return this.openSourceFileAtLocation(binaryLoc, filename, lineNumber);
    }

    public boolean openSourceFileAtLocation(IPath binaryLoc, String sourceLoc, String lineNumber) throws IOException {
        int _lineNumber = -1;
        try {
            _lineNumber = Integer.parseInt(lineNumber);
        }
        catch (Exception exception) {}
        return this.openSourceFileAtLocation(binaryLoc, sourceLoc, _lineNumber);
    }

    public boolean openSourceFileAtLocation(IPath binaryLoc, String sourceLoc, int lineNumber) throws IOException {
        if (sourceLoc == null) {
            return false;
        }
        Path p = new Path(sourceLoc);
        return this.openSourceFileAtLocation(binaryLoc, (IPath)p, lineNumber);
    }

    public boolean openSourceFileAtLocation(IPath binaryLoc, IPath sourceLoc, int lineNumber) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile binary = root.getFileForLocation(binaryLoc);
        IProject project = null;
        if (binary != null) {
            project = binary.getProject();
        }
        return this.openFileImpl(project, sourceLoc, lineNumber);
    }

    public boolean openSourceFileAtLocation(IProject project, String sourceLoc, int lineNumber) throws IOException {
        if (sourceLoc == null) {
            return false;
        }
        Path p = new Path(sourceLoc);
        return this.openFileImpl(project, (IPath)p, lineNumber);
    }

    public boolean openSourceFileAtLocation(IProject project, IPath sourceLoc, int lineNumber) {
        return this.openFileImpl(project, sourceLoc, lineNumber);
    }

    public boolean openSourceFileAtAddress(IPath binaryLoc, long address) throws IOException {
        IBinaryParser.IBinaryObject bf = STSymbolManager.sharedInstance.getBinaryObject(binaryLoc);
        if (bf != null) {
            return this.openSourceFileAtAddress(bf, address);
        }
        return false;
    }

    public boolean openSourceFileAtAddress(IPath binaryLoc, String address) throws IOException {
        IBinaryParser.IBinaryObject bf = STSymbolManager.sharedInstance.getBinaryObject(binaryLoc);
        if (bf != null) {
            return this.openSourceFileAtAddress(bf, address);
        }
        return false;
    }

    private String getFileName(String loc) {
        int index1;
        String filename = null;
        if (loc != null && (index1 = loc.lastIndexOf(58)) != -1) {
            int index2 = loc.indexOf(58);
            index2 = index1 == index2 ? 0 : --index2;
            filename = loc.substring(index2, index1);
        }
        return filename;
    }

    private int getLineNumber(String loc) {
        int colon;
        String number;
        if (loc != null && !(number = loc.substring((colon = loc.lastIndexOf(58)) + 1)).startsWith("0")) {
            try {
                return Integer.parseInt(number);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public boolean openSourceFileAtSymbol(IBinaryParser.IBinaryObject binary, IBinaryParser.ISymbol symbol) {
        if (symbol == null) {
            return false;
        }
        String loc = STSymbolManager.sharedInstance.getLine(symbol);
        return this.openSourceFileAtLocation(binary, loc);
    }

    public boolean openSourceFileAtLocation(IBinaryParser.IBinaryObject binary, String addr2lineOutput) {
        String filename = this.getFileName(addr2lineOutput);
        int lineNumber = this.getLineNumber(addr2lineOutput);
        return this.openSourceFileAtLocation(binary, filename, lineNumber);
    }

    public boolean openSourceFileAtLocation(IBinaryParser.IBinaryObject binary, String sourceLoc, String lineNumber) {
        int i = -1;
        try {
            i = Integer.parseInt(lineNumber);
        }
        catch (Exception exception) {}
        return this.openSourceFileAtLocation(binary, sourceLoc, i);
    }

    public boolean openSourceFileAtLocation(IBinaryParser.IBinaryObject binary, String sourceLoc, int lineNumber) {
        if (sourceLoc == null) {
            return false;
        }
        Path p = new Path(sourceLoc);
        return this.openSourceFileAtLocation(binary.getPath(), (IPath)p, lineNumber);
    }

    public boolean openSourceFileAtAddress(IBinaryParser.IBinaryObject binary, IAddress address) {
        if (binary == null) {
            return false;
        }
        String loc = STSymbolManager.sharedInstance.getLine(binary, address);
        return this.openSourceFileAtLocation(binary, loc);
    }

    public boolean openSourceFileAtAddress(IBinaryParser.IBinaryObject binary, long address) {
        String addr = Long.toString(address);
        return this.openSourceFileAtAddress(binary, addr);
    }

    public boolean openSourceFileAtAddress(IBinaryParser.IBinaryObject binary, String address) {
        if (binary == null) {
            return false;
        }
        IAddressFactory factory = binary.getAddressFactory();
        Object addr = factory == null ? new Addr64(address) : factory.createAddress(address);
        return this.openSourceFileAtAddress(binary, (IAddress)addr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openFileImpl(IProject project, IPath sourceLoc, int lineNumber) {
        if (sourceLoc == null) return false;
        if ("??".equals(sourceLoc.toString())) {
            return false;
        }
        try {
            IEditorInput editorInput = this.getEditorInput(sourceLoc, project);
            IWorkbenchPage p = CUIPlugin.getActivePage();
            if (p == null) return false;
            if (editorInput == null) {
                p.openEditor((IEditorInput)new STCSourceNotFoundEditorInput(project, sourceLoc, lineNumber), "org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditor", true);
                return false;
            }
            IEditorPart editor = p.openEditor(editorInput, "org.eclipse.cdt.ui.editor.CEditor", true);
            if (lineNumber <= 0) return false;
            if (!(editor instanceof ITextEditor)) return false;
            IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
            IDocument document = provider.getDocument((Object)editor.getEditorInput());
            try {
                int start = document.getLineOffset(lineNumber - 1);
                ((ITextEditor)editor).selectAndReveal(start, 0);
                IWorkbenchPage page = editor.getSite().getPage();
                page.activate((IWorkbenchPart)editor);
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public IEditorInput getEditorInput(IPath p, IProject project) {
        File file;
        IFile f = this.getFileForPath(p, project);
        if (f != null && f.exists()) {
            return new FileEditorInput(f);
        }
        if (p.isAbsolute() && (file = p.toFile()).exists()) {
            try {
                IFileStore ifs = EFS.getStore((URI)file.toURI());
                return new FileStoreEditorInput(ifs);
            }
            catch (CoreException _) {
                Activator.getDefault().getLog().log(_.getStatus());
            }
        }
        return this.findFileInCommonSourceLookup(p);
    }

    private IEditorInput findFileInCommonSourceLookup(IPath path) {
        try {
            ISourceContainer[] c;
            CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
            ISourceContainer[] iSourceContainerArray = c = director.getSourceContainers();
            int n = c.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] o;
                ISourceContainer sourceContainer = iSourceContainerArray[n2];
                Object[] objectArray = o = sourceContainer.findSourceElements(path.toOSString());
                int n3 = o.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray[n4];
                    if (object instanceof IFile) {
                        return new FileEditorInput((IFile)object);
                    }
                    if (object instanceof LocalFileStorage) {
                        LocalFileStorage storage = (LocalFileStorage)object;
                        IFileStore ifs = EFS.getStore((URI)storage.getFile().toURI());
                        return new FileStoreEditorInput(ifs);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private IFile getFileForPath(IPath path, IProject project) {
        IFile f = this.getFileForPathImpl(path, project);
        if (f == null) {
            HashSet<IProject> allProjects = new HashSet<IProject>();
            try {
                this.getAllReferencedProjects(allProjects, project);
            }
            catch (CoreException _) {
                Activator.getDefault().getLog().log(_.getStatus());
            }
            if (allProjects != null) {
                for (IProject project2 : allProjects) {
                    f = this.getFileForPathImpl(path, project2);
                    if (f != null) break;
                }
            }
        }
        return f;
    }

    private IFile getFileForPathImpl(IPath path, IProject project) {
        ICProject cproject;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.isAbsolute()) {
            IFile c = root.getFileForLocation(path);
            return c;
        }
        if (project != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IOutputEntry[] entries;
                ISourceRoot[] roots;
                ISourceRoot[] iSourceRootArray = roots = cproject.getAllSourceRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer parent;
                    IResource res;
                    ISourceRoot sourceRoot = iSourceRootArray[n2];
                    IResource r = sourceRoot.getResource();
                    if (r instanceof IContainer && (res = (parent = (IContainer)r).findMember(path)) != null && res.exists() && res instanceof IFile) {
                        IFile file = (IFile)res;
                        return file;
                    }
                    ++n2;
                }
                IOutputEntry[] iOutputEntryArray = entries = cproject.getOutputEntries();
                int n3 = entries.length;
                n = 0;
                while (n < n3) {
                    IContainer parent;
                    IResource res;
                    IOutputEntry pathEntry = iOutputEntryArray[n];
                    IPath p = pathEntry.getPath();
                    IResource r = root.findMember(p);
                    if (r instanceof IContainer && (res = (parent = (IContainer)r).findMember(path)) != null && res.exists() && res instanceof IFile) {
                        IFile file = (IFile)res;
                        return file;
                    }
                    ++n;
                }
            }
            catch (CModelException _) {
                Activator.getDefault().getLog().log(_.getStatus());
            }
        }
        return null;
    }

    private void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        if (project != null) {
            IProject[] refs = project.getReferencedProjects();
            int i = 0;
            while (i < refs.length) {
                if (!all.contains(refs[i]) && refs[i].exists() && refs[i].isOpen()) {
                    all.add(refs[i]);
                    this.getAllReferencedProjects(all, refs[i]);
                }
                ++i;
            }
        }
    }
}

