/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngEventType;
import org.eclipse.linuxtools.lttng.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.model.LTTngTreeNode;
import org.eclipse.linuxtools.lttng.request.LttngBaseEventRequest;
import org.eclipse.linuxtools.lttng.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.lttng.state.evProcessor.state.StateEventToHandlerFactory;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.state.trace.IStateTraceManager;
import org.eclipse.linuxtools.tmf.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfStartSynchSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.trace.TmfContext;

public class LttngSyntheticEventProvider
extends TmfEventProvider<LttngSyntheticEvent> {
    public static final int BLOCK_SIZE = 50000;
    public static final int NB_EVENTS = 1;
    public static final int QUEUE_SIZE = 1;
    private ITmfDataRequest<LttngSyntheticEvent> fmainRequest = null;
    private LttngBaseEventRequest fSubRequest = null;
    private final List<IStateTraceManager> fEventProviderRequests = new Vector<IStateTraceManager>();
    private final LttngSyntheticEvent fStatusEvent;
    volatile boolean startIndSent = false;
    private LTTngTreeNode fExperiment = null;
    private ITransEventProcessor fstateUpdateProcessor = StateEventToHandlerFactory.getInstance();
    private boolean waitForRequest = false;
    long dispatchTime = 0L;
    long dispatchIndex = 0L;
    long eventIndex;
    private final Map<ITmfTrace, LttngTraceState> traceToTraceStateModel = new HashMap<ITmfTrace, LttngTraceState>();
    private boolean fIsExperimentNotified = false;

    LttngSyntheticEventProvider(Class<LttngSyntheticEvent> type) {
        super("LttngSyntheticEventProvider", type, 1);
        TmfEventSource source = new TmfEventSource((Object)this);
        LttngEventType dtype = new LttngEventType();
        LttngTimestamp statusTimeStamp = new LttngTimestamp(TmfTimestamp.Zero);
        this.fStatusEvent = new LttngSyntheticEvent(null, statusTimeStamp, source, dtype, null, null, null);
        this.fStatusEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.STARTREQ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITmfContext armRequest(ITmfDataRequest<LttngSyntheticEvent> request) {
        if (!(request instanceof ITmfEventRequest)) {
            request.cancel();
            TraceDebug.debug("Request is not an instance of ITmfEventRequest");
            return null;
        }
        if (this.fExperiment == null) {
            TraceDebug.debug("Experiment is null");
            request.cancel();
            return null;
        }
        this.reset(this.fExperiment);
        if (this.fEventProviderRequests.size() < 1) {
            request.cancel();
            TraceDebug.debug("No Base event providers available");
            return null;
        }
        this.fmainRequest = request;
        ITmfEventRequest eventRequest = (ITmfEventRequest)this.fmainRequest;
        TmfTimeRange reqWindow = eventRequest.getRange();
        TraceDebug.debug("Main Synthethic event request started on thread:  " + Thread.currentThread().getName());
        TmfExperiment experiment = (TmfExperiment)this.fExperiment.getValue();
        experiment.startSynch(new TmfStartSynchSignal(0));
        TmfTimeRange adjustedRange = reqWindow;
        long adjustedIndex = eventRequest.getIndex();
        int nbRequested = eventRequest.getNbRequested();
        for (IStateTraceManager traceManager : this.fEventProviderRequests) {
            TmfCheckpoint checkPoint = null;
            checkPoint = eventRequest.getIndex() > 0 ? traceManager.restoreCheckPointByIndex(eventRequest.getIndex()) : traceManager.restoreCheckPointByTimestamp(reqWindow.getStartTime());
            TmfTimeRange traceRange = traceManager.getTrace().getTimeRange();
            if (checkPoint != null && checkPoint.getTimestamp().getValue() >= traceRange.getStartTime().getValue() && checkPoint.getTimestamp().getValue() <= traceRange.getEndTime().getValue() && checkPoint.getTimestamp().getValue() < reqWindow.getEndTime().getValue() && (adjustedRange.getStartTime().getValue() > checkPoint.getTimestamp().getValue() || adjustedIndex > (Long)checkPoint.getLocation().getLocation())) {
                adjustedRange = new TmfTimeRange(checkPoint.getTimestamp(), reqWindow.getEndTime());
                adjustedIndex = (Long)checkPoint.getLocation().getLocation();
                if (nbRequested < Integer.MAX_VALUE) {
                    nbRequested = (int)((long)nbRequested + ((long)eventRequest.getIndex() - adjustedIndex));
                }
            }
            this.traceToTraceStateModel.put(traceManager.getTrace(), traceManager.getStateModel());
        }
        this.dispatchTime = reqWindow.getStartTime().getValue();
        this.dispatchIndex = eventRequest.getIndex();
        this.eventIndex = adjustedIndex;
        this.fSubRequest = new LttngBaseEventRequest(adjustedRange, reqWindow.getStartTime(), adjustedIndex, nbRequested, 50000, eventRequest.getExecType()){
            private LttngSyntheticEvent syntheticEvent;
            {
                this.syntheticEvent = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleData(LttngEvent event) {
                super.handleData((TmfData)event);
                if (event != null) {
                    LttngSyntheticEventProvider lttngSyntheticEventProvider = LttngSyntheticEventProvider.this;
                    synchronized (lttngSyntheticEventProvider) {
                        if (LttngSyntheticEventProvider.this.fmainRequest == null || LttngSyntheticEventProvider.this.fmainRequest.isCompleted()) {
                            TraceDebug.debug("fmainRequest was canceled. Ignoring event " + (Object)((Object)event));
                            return;
                        }
                        this.handleIncomingData(event);
                    }
                } else {
                    TraceDebug.debug("handle data received with no data");
                }
            }

            public void handleCompleted() {
                LttngSyntheticEventProvider.this.handleProviderDone(!this.isCancelled() && !this.isFailed());
                super.handleCompleted();
            }

            private void handleIncomingData(LttngEvent e) {
                long eventTime = e.getTimestamp().getValue();
                ITmfTrace inTrace = e.getParentTrace();
                LttngTraceState traceModel = (LttngTraceState)LttngSyntheticEventProvider.this.traceToTraceStateModel.get(inTrace);
                this.updateSynEvent(e);
                if (eventTime >= LttngSyntheticEventProvider.this.dispatchTime && LttngSyntheticEventProvider.this.eventIndex >= LttngSyntheticEventProvider.this.dispatchIndex) {
                    this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.BEFORE);
                    LttngSyntheticEventProvider.this.fmainRequest.handleData((TmfData)this.syntheticEvent);
                    this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.UPDATE);
                    LttngSyntheticEventProvider.this.fstateUpdateProcessor.process(this.syntheticEvent, traceModel);
                    this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.AFTER);
                    LttngSyntheticEventProvider.this.fmainRequest.handleData((TmfData)this.syntheticEvent);
                } else {
                    this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.UPDATE);
                    LttngSyntheticEventProvider.this.fstateUpdateProcessor.process(this.syntheticEvent, traceModel);
                }
                ++LttngSyntheticEventProvider.this.eventIndex;
            }

            private LttngSyntheticEvent updateSynEvent(LttngEvent e) {
                if (this.syntheticEvent == null || this.syntheticEvent.getBaseEvent() != e) {
                    this.syntheticEvent = new LttngSyntheticEvent(e);
                }
                ITmfTrace inTrace = e.getParentTrace();
                LttngTraceState traceModel = (LttngTraceState)LttngSyntheticEventProvider.this.traceToTraceStateModel.get(inTrace);
                this.syntheticEvent.setTraceModel(traceModel);
                if (!LttngSyntheticEventProvider.this.startIndSent) {
                    TraceDebug.debug("Thread started: " + Thread.currentThread().getName());
                    LttngSyntheticEventProvider.this.handleProviderStarted(traceModel);
                    LttngSyntheticEventProvider.this.startIndSent = true;
                }
                return this.syntheticEvent;
            }
        };
        TmfExperiment provider = (TmfExperiment)this.fExperiment.getValue();
        provider.sendRequest((ITmfDataRequest)this.fSubRequest);
        LttngSyntheticEventProvider lttngSyntheticEventProvider = this;
        synchronized (lttngSyntheticEventProvider) {
            TmfExperiment.getCurrentExperiment().notifyPendingRequest(false);
            this.fIsExperimentNotified = false;
        }
        experiment.endSynch(new TmfEndSynchSignal(0));
        return new TmfContext();
    }

    public synchronized void handleProviderStarted(LttngTraceState traceModel) {
        LttngSyntheticEvent startIndEvent = new LttngSyntheticEvent(this.fStatusEvent);
        startIndEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.STARTREQ);
        this.fmainRequest.handleData((TmfData)startIndEvent);
        this.fstateUpdateProcessor.process(startIndEvent, (LttngTraceState)null);
    }

    public synchronized void handleProviderDone(boolean isSuccess) {
        for (LttngTraceState traceModel : this.traceToTraceStateModel.values()) {
            LttngSyntheticEvent finishEvent = new LttngSyntheticEvent(this.fStatusEvent);
            finishEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.ENDREQ);
            finishEvent.setTraceModel(traceModel);
            this.fmainRequest.handleData((TmfData)finishEvent);
        }
        if (isSuccess) {
            this.fmainRequest.done();
        } else {
            this.fmainRequest.cancel();
        }
    }

    public synchronized void reset(LTTngTreeNode experimentNode) {
        this.conditionallyCancelRequests();
        this.fEventProviderRequests.clear();
        this.startIndSent = false;
        if (this.fExperiment != null) {
            LTTngTreeNode[] traces;
            LTTngTreeNode[] lTTngTreeNodeArray = traces = this.fExperiment.getChildren();
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                LTTngTreeNode trace = lTTngTreeNodeArray[n2];
                IStateTraceManager traceBaseEventProvider = (IStateTraceManager)((Object)trace);
                this.fEventProviderRequests.add(traceBaseEventProvider);
                ++n2;
            }
        }
        if (this.fExperiment != experimentNode) {
            this.updateExperimentNode(experimentNode);
        }
    }

    private synchronized void updateExperimentNode(LTTngTreeNode experiment) {
        if (experiment != null && experiment.getValue() instanceof TmfExperiment) {
            this.fExperiment = experiment;
        } else {
            TraceDebug.debug("Experiment received is not instance of TmfExperiment: " + experiment.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(ITmfDataRequest<LttngSyntheticEvent> request) {
        LttngSyntheticEventProvider lttngSyntheticEventProvider = this;
        synchronized (lttngSyntheticEventProvider) {
            TmfExperiment experiment;
            if (!this.fIsExperimentNotified && (experiment = TmfExperiment.getCurrentExperiment()) != null) {
                experiment.notifyPendingRequest(true);
                this.fIsExperimentNotified = true;
            }
        }
        super.sendRequest(request);
        if (this.waitForRequest) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isWaitForRequest() {
        return this.waitForRequest;
    }

    public void setWaitForRequest(boolean waitForRequest) {
        this.waitForRequest = waitForRequest;
    }

    public LttngSyntheticEvent getNext(ITmfContext context) {
        try {
            this.fmainRequest.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized void conditionallyCancelRequests() {
        if (this.fSubRequest != null && !this.fSubRequest.isCompleted()) {
            TraceDebug.debug("Canceling synthethic event request!");
            this.fSubRequest.cancel();
            this.fSubRequest = null;
            this.fmainRequest = null;
        }
    }

    protected void queueBackgroundRequest(ITmfDataRequest<LttngSyntheticEvent> request, int blockSize, boolean indexing) {
        this.queueRequest(request);
    }
}

