/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMPacket;

public class DMRequest
extends DMPacket {
    public static final int packetsize = 28;
    public static final int CREATE_CONN = 1;
    public static final int SUBSCRIBE = 2;
    public static final int UNSUBSCRIBE = 3;
    public static final int GET_STATUS = 4;
    public static final int SUBSCRIPTION_MODIFY = 5;
    public static final int DESTROY_CONN = 6;
    public static final int FILE = 7;
    private final int reqType;
    private final boolean isGuru;

    public DMRequest(int reqType, int scriptID, int clientID, int size) {
        this.reqType = reqType;
        this.scriptID = scriptID;
        this.filename = "";
        this.clientID = clientID;
        this.size = size;
        this.isGuru = false;
    }

    public DMRequest(int reqType, int scriptnum, String filename, int clientID, int size, boolean isGuru) {
        this.reqType = reqType;
        this.filename = filename;
        this.scriptID = scriptnum;
        this.clientID = clientID;
        this.size = size;
        this.isGuru = isGuru;
    }

    public byte[] getData() {
        if (this.reqType == 2) {
            return this.getFile();
        }
        return this.getMessage();
    }

    public int getReqtype() {
        return this.reqType;
    }

    private byte[] getMessage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        char[] a = new char[20];
        int i = 0;
        while (i < 20) {
            a[i] = 32;
            ++i;
        }
        String b = ConsoleLogPlugin.getDefault().getPluginPreferences().getString("scpuser");
        b.getChars(0, b.length(), a, 0);
        b = null;
        b = String.copyValueOf(a);
        try {
            dos.writeInt(-1582119980);
            dos.writeInt(this.reqType);
            dos.writeInt(this.scriptID);
            dos.writeInt(this.clientID);
            dos.writeInt(0);
            dos.writeInt(ConsoleLogPlugin.getDefault().getPluginPreferences().getString("scpuser").length());
            dos.writeBytes(b);
            dos.flush();
        }
        catch (IOException ioe) {
            new ErrorMessage("Request packet error!", "See stderr for more details").open();
            System.err.println("Packet Error: " + ioe.getMessage());
            return null;
        }
        return baos.toByteArray();
    }

    private byte[] getFile() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(-1582119980);
            dos.writeInt(this.reqType);
            dos.writeInt(this.scriptID);
            dos.writeInt(this.clientID);
            if (this.isGuru) {
                dos.writeInt(1);
            } else {
                dos.writeInt(0);
            }
            dos.writeInt(this.filename.length());
            dos.writeBytes(this.filename.substring(this.filename.lastIndexOf(47)));
            dos.flush();
            return baos.toByteArray();
        }
        catch (Exception ioe) {
            new ErrorMessage("Request packet error!", "See stderr for more details").open();
            System.err.println("Packet Error: " + ioe.getMessage());
            return null;
        }
    }

    public String toString() {
        return "ID String:\t-1582119980\nRequest Type:\t" + this.reqType + "\nScript #:\t" + this.scriptID + "\nFilename:\t" + this.filename + "\nClient ID:\t" + this.clientID + "\nData Size:\t" + this.size + "\n";
    }
}

