/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.piechart;

import org.eclipse.linuxtools.dataviewers.piechart.IColorsConstants;
import org.eclipse.linuxtools.dataviewers.piechart.PieChartPaintListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class PieChart
extends Chart {
    public PieChart(Composite parent, int style) {
        super(parent, style);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getClass().getName().equals("org.swtchart.internal.axis.AxisTitle") || child.getClass().getName().equals("org.swtchart.internal.PlotArea")) {
                child.setVisible(false);
            }
            ++n2;
        }
        this.addPaintListener(new PieChartPaintListener(this));
    }

    public void addPaintListener(PaintListener listener) {
        if (!listener.getClass().getName().startsWith("org.swtchart.internal.axis")) {
            super.addPaintListener(listener);
        }
    }

    public void addPieChartSeries(String[] labels, double[] val) {
        ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            this.getSeriesSet().deleteSeries(s.getId());
            ++n2;
        }
        double[][] newVal = new double[val.length][1];
        int i = 0;
        while (i < val.length) {
            newVal[i][0] = val[i];
            ++i;
        }
        this.addPieChartSeries(labels, newVal);
    }

    public void addPieChartSeries(String[] labels, double[][] val) {
        ISeries[] iSeriesArray = this.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            this.getSeriesSet().deleteSeries(s.getId());
            ++n2;
        }
        int size = Math.min(labels.length, val.length);
        int i = 0;
        while (i < size) {
            IBarSeries s = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, labels[i]);
            double[] d = new double[val[i].length];
            int j = 0;
            while (j < val[i].length) {
                d[j] = val[i][j];
                ++j;
            }
            s.setXSeries(d);
            s.setBarColor(new Color((Device)this.getDisplay(), IColorsConstants.COLORS[i]));
            ++i;
        }
    }
}

