/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets;

import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class GraphComposite
extends Composite {
    private SelectionListener scaleListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Scale scaler = (Scale)e.widget;
            int index = scaler.getSelection();
            if (GraphComposite.this.scale != scales[index]) {
                GraphComposite.this.scale = scales[index];
                GraphComposite.this.builder.setScale(GraphComposite.this.scale);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private boolean sidebarVisible = true;
    private AbstractChartBuilder builder;
    private Scale zoomScale;
    public double scale;
    private static final double[] scales = new double[]{0.0625, 0.125, 0.25, 0.33, 0.5, 0.66, 0.8, 1.0, 1.25, 1.5, 2.0, 3.0, 4.0, 8.0, 16.0};
    private Label label;
    private Label pluslabel;
    private ArrayList<Button> checkOptions;

    public GraphComposite(Composite parent, int style, GraphData gd, IDataSet ds) {
        super(parent, style);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.checkOptions = new ArrayList();
        this.label = new Label((Composite)this, 0x1000901);
        this.scale = scales[7];
        this.label.setText("-");
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, -4);
        data.left = new FormAttachment(0, 2);
        data.width = 15;
        this.label.setLayoutData((Object)data);
        this.label.setFont(new Font((Device)parent.getDisplay(), "Arial", 10, 1));
        this.zoomScale = new Scale((Composite)this, 256);
        this.zoomScale.setMinimum(0);
        this.zoomScale.setMaximum(14);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(1);
        this.zoomScale.setSelection(7);
        this.zoomScale.setToolTipText("Increase/Decrease the no of X axis ticks");
        data = new FormData();
        data.left = new FormAttachment((Control)this.label, 2);
        data.bottom = new FormAttachment(100, -4);
        data.right = new FormAttachment(100, -20);
        this.zoomScale.setLayoutData((Object)data);
        this.pluslabel = new Label((Composite)this, 0x1000901);
        this.pluslabel.setText("+");
        this.pluslabel.setFont(new Font((Device)parent.getDisplay(), "Arial", 10, 1));
        data = new FormData();
        data.left = new FormAttachment((Control)this.zoomScale, 2);
        data.bottom = new FormAttachment(100, -4);
        data.width = 15;
        this.pluslabel.setLayoutData((Object)data);
        this.builder = GraphFactory.createGraph(this, style, gd, ds);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)this.label, -5);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        this.builder.build();
        this.builder.setLayoutData(data);
        this.zoomScale.addSelectionListener(this.scaleListener);
        if (this.builder instanceof AbstractChartWithoutAxisBuilder) {
            this.configure(false);
        }
    }

    public void configure(boolean withSidebar) {
        this.sidebarVisible = withSidebar;
        int i = 0;
        while (i < this.checkOptions.size()) {
            this.checkOptions.get(i).setVisible(this.sidebarVisible);
            ++i;
        }
        this.zoomScale.setVisible(this.sidebarVisible);
        this.label.setVisible(this.sidebarVisible);
        this.pluslabel.setVisible(this.sidebarVisible);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = withSidebar ? new FormAttachment((Control)this.label, -7) : new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.builder.setLayoutData(data);
        this.layout(true, true);
    }

    public void addCheckOption(String title, SelectionListener listener) {
        Button b = new Button((Composite)this, 32);
        b.setText(title);
        Button old = null;
        if (this.checkOptions.size() > 0) {
            old = this.checkOptions.get(this.checkOptions.size() - 1);
        }
        FormData data = new FormData();
        data.bottom = old != null ? new FormAttachment((Control)old, 0) : new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        data.width = 85;
        b.setLayoutData((Object)data);
        b.addSelectionListener(listener);
        this.checkOptions.add(b);
        if (this.checkOptions.size() == 1) {
            ((FormData)this.label.getLayoutData()).right = new FormAttachment((Control)b, 0);
            ((FormData)this.zoomScale.getLayoutData()).right = new FormAttachment((Control)b, 0);
        }
    }

    public void removeCheckOption(String title) {
        int i = 0;
        while (i < this.checkOptions.size()) {
            Button b = this.checkOptions.get(i);
            if (b.getText().equals(title)) {
                this.checkOptions.remove(b);
                if (this.checkOptions.size() == 0) {
                    ((FormData)this.label.getLayoutData()).right = new FormAttachment(100, 0);
                }
                return;
            }
            ++i;
        }
    }

    public AbstractChartBuilder getCanvas() {
        return this.builder;
    }

    public boolean isSidebarVisible() {
        return this.sidebarVisible;
    }

    public void dispose() {
        this.scaleListener = null;
        if (this.zoomScale != null) {
            this.zoomScale.dispose();
        }
        this.zoomScale = null;
        if (this.label != null) {
            this.label.dispose();
        }
        this.label = null;
        super.dispose();
    }
}

