/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.internal.Messages;

public class MavenSessionHelper {
    private final IMavenProjectFacade facade;
    private MavenProject project;
    private Set<Artifact> artifacts;
    private Set<Artifact> dependencyArtifacts;

    public MavenSessionHelper(IMavenProjectFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(Messages.Error_Maven_Project_Cant_Be_Null);
        }
        this.facade = facade;
    }

    public void ensureDependenciesAreResolved(String pluginId, String goal, IProgressMonitor monitor) throws CoreException {
        this.project = this.facade.getMavenProject(monitor);
        MavenExecutionPlan executionPlan = MavenPlugin.getMaven().calculateExecutionPlan(this.project, Collections.singletonList(goal), true, monitor);
        MojoExecution execution = MavenSessionHelper.getExecution(executionPlan, pluginId);
        IMavenExecutionContext context = this.facade.createExecutionContext();
        context.execute(this.project, (ctx, pm) -> {
            this.ensureDependenciesAreResolved(ctx, execution, monitor);
            return null;
        }, monitor);
    }

    private void ensureDependenciesAreResolved(IMavenExecutionContext ctx, MojoExecution execution, IProgressMonitor monitor) {
        MavenSession session = ctx.getSession();
        try {
            this.artifacts = this.project.getArtifacts();
            this.dependencyArtifacts = this.project.getDependencyArtifacts();
            MojoExecutor mojoExecutor = (MojoExecutor)ctx.getComponentLookup().lookup(MojoExecutor.class);
            DependencyContext dependencyContext = mojoExecutor.newDependencyContext(session, List.of(execution));
            mojoExecutor.ensureDependenciesAreResolved(execution.getMojoDescriptor(), session, dependencyContext);
        }
        catch (Exception ex) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.project != null) {
            this.project.setArtifactFilter(null);
            this.project.setResolvedArtifacts(null);
            this.project.setArtifacts(this.artifacts);
            this.project.setDependencyArtifacts(this.dependencyArtifacts);
        }
    }

    public static MojoExecution getExecution(MavenExecutionPlan executionPlan, String artifactId) throws CoreException {
        if (executionPlan == null) {
            return null;
        }
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!artifactId.equals(execution.getArtifactId())) continue;
            return execution;
        }
        return null;
    }

    public MavenProject getMavenProject() {
        return this.project;
    }
}

