/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import org.eclipse.compare.CompareUI;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.history.data.AffectedPathsNode;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;

public class AffectedPathsLabelProvider
extends LabelProvider {
    protected static Image folderIcon;
    protected static Image overlayedFolderIcon;
    protected static Image rootIcon;
    protected static Image rootAdditionIcon;
    protected static Image overlayedRootIcon;
    protected static Image addedFolderIcon;
    protected static Image modifiedFolderIcon;
    protected static Image deletedFolderIcon;
    protected static Image replacedFolderIcon;
    protected long currentRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AffectedPathsLabelProvider() {
        Class<AffectedPathsLabelProvider> clazz = AffectedPathsLabelProvider.class;
        synchronized (AffectedPathsLabelProvider.class) {
            if (folderIcon == null) {
                SVNTeamUIPlugin instance = SVNTeamUIPlugin.instance();
                folderIcon = instance.getImageDescriptor("icons/views/history/affected_folder.gif").createImage();
                overlayedFolderIcon = new OverlayedImageDescriptor(folderIcon, instance.getImageDescriptor("icons/overlays/empty.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                rootIcon = instance.getImageDescriptor("icons/objects/repository-root.gif").createImage();
                rootAdditionIcon = new OverlayedImageDescriptor(rootIcon, instance.getImageDescriptor("icons/overlays/addition.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                overlayedRootIcon = new OverlayedImageDescriptor(rootIcon, instance.getImageDescriptor("icons/overlays/empty.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                addedFolderIcon = new OverlayedImageDescriptor(folderIcon, instance.getImageDescriptor("icons/overlays/addition.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                modifiedFolderIcon = new OverlayedImageDescriptor(folderIcon, instance.getImageDescriptor("icons/overlays/change.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                deletedFolderIcon = new OverlayedImageDescriptor(folderIcon, instance.getImageDescriptor("icons/overlays/deletion.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                replacedFolderIcon = new OverlayedImageDescriptor(folderIcon, instance.getImageDescriptor("icons/overlays/replacement.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
                CompareUI.disposeOnShutdown((Image)folderIcon);
                CompareUI.disposeOnShutdown((Image)overlayedFolderIcon);
                CompareUI.disposeOnShutdown((Image)rootIcon);
                CompareUI.disposeOnShutdown((Image)rootAdditionIcon);
                CompareUI.disposeOnShutdown((Image)overlayedRootIcon);
                CompareUI.disposeOnShutdown((Image)addedFolderIcon);
                CompareUI.disposeOnShutdown((Image)modifiedFolderIcon);
                CompareUI.disposeOnShutdown((Image)deletedFolderIcon);
                CompareUI.disposeOnShutdown((Image)replacedFolderIcon);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setCurrentRevision(long currentRevision) {
        this.currentRevision = currentRevision;
    }

    public Image getImage(Object element) {
        if (((AffectedPathsNode)element).getParent() == null) {
            return this.currentRevision == 0L ? rootAdditionIcon : overlayedRootIcon;
        }
        if (((AffectedPathsNode)element).getStatus() != null) {
            switch (((AffectedPathsNode)element).getStatus()) {
                case ADDED: {
                    return addedFolderIcon;
                }
                case MODIFIED: {
                    return modifiedFolderIcon;
                }
                case DELETED: {
                    return deletedFolderIcon;
                }
                case REPLACED: {
                    return replacedFolderIcon;
                }
            }
        }
        return overlayedFolderIcon;
    }
}

