/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRemoteContentsOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResourceProvider provider;
    protected HashMap<String, String> remotePath2localPath;
    protected long options;

    public GetRemoteContentsOperation(IResource[] resources, final IRepositoryResource[] remoteResources, HashMap<String, String> remotePath2localPath, boolean ignoreExternals) {
        this(resources, new IRepositoryResourceProvider(){

            public IRepositoryResource[] getRepositoryResources() {
                return remoteResources;
            }
        }, remotePath2localPath, ignoreExternals);
    }

    public GetRemoteContentsOperation(IResource[] resources, IRepositoryResourceProvider provider, HashMap<String, String> remotePath2localPath, boolean ignoreExternals) {
        this(resources, provider, remotePath2localPath, 4L | (ignoreExternals ? 1L : 0L));
    }

    public GetRemoteContentsOperation(IResource[] resources, IRepositoryResourceProvider provider, HashMap<String, String> remotePath2localPath, long options) {
        super("Operation_GetContent", SVNMessages.class, resources);
        this.provider = provider;
        this.remotePath2localPath = remotePath2localPath;
        this.options = options & 0x400000005L;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] remoteResources = this.provider.getRepositoryResources();
        int i = 0;
        while (i < remoteResources.length && !monitor.isCanceled()) {
            final IRepositoryResource remote = remoteResources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    GetRemoteContentsOperation.this.doGet(remote, monitor);
                }
            }, monitor, remoteResources.length);
            ++i;
        }
    }

    protected void doGet(IRepositoryResource remote, IProgressMonitor monitor) throws Exception {
        block19: {
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                String url = SVNUtility.encodeURL(remote.getUrl());
                String wcPath = this.remotePath2localPath.get(url);
                if (remote instanceof IRepositoryFile) {
                    File file;
                    File parent = new File(wcPath.substring(0, wcPath.lastIndexOf("/")));
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    if (!(file = new File(wcPath)).exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream stream = null;
                    try {
                        try {
                            this.writeToConsole(0, "svn cat " + url + "@" + remote.getPegRevision() + " -r " + remote.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                            stream = new FileOutputStream(wcPath);
                            proxy.streamFileContent(SVNUtility.getEntryRevisionReference(remote), 2048L, stream, new SVNProgressMonitor(this, monitor, null));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (stream == null) break block19;
                            try {
                                stream.close();
                                break block19;
                            }
                            catch (Exception exception) {}
                        }
                        break block19;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                File directory = new File(wcPath);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                this.writeToConsole(0, "svn export " + url + "@" + remote.getPegRevision() + " -r " + remote.getSelectedRevision() + ISVNConnector.Options.asCommandLine(this.options) + " \"" + wcPath + "\" " + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.exportTo(SVNUtility.getEntryRevisionReference(remote), wcPath, null, SVNDepth.INFINITY, this.options, new SVNProgressMonitor(this, monitor, null));
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{FileUtility.getNamesListAsString(this.provider.getRepositoryResources())});
    }
}

