/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreateFileOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected String[] fileNames;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFileOperation(IRepositoryResource resource, String path, String message, String[] fileNames) {
        super("Operation_CreateFile", SVNMessages.class, new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.fileNames = fileNames;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IRepositoryResource resource = this.operableData()[0];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        final ISVNConnector proxy = location.acquireSVNProxy();
        ISVNNotificationCallback notify = new ISVNNotificationCallback(){

            public void notify(SVNNotification info) {
                if (info.revision != -1L) {
                    String[] path = new String[]{resource.getUrl()};
                    CreateFileOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                    String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                    CreateFileOperation.this.writeToConsole(1, message);
                }
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            int i = 0;
            while (i < this.fileNames.length) {
                final String[] currentFile = new String[]{this.fileNames[i]};
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        String path = FileUtility.normalizePath(String.valueOf(CreateFileOperation.this.path) + "/" + currentFile[0]);
                        String url = String.valueOf(resource.getUrl()) + "/" + currentFile[0];
                        CreateFileOperation.this.writeToConsole(0, "svn import \"" + path + "\" \"" + url + "\" -m \"" + CreateFileOperation.this.message + "\"" + ISVNConnector.Options.asCommandLine(4352L) + FileUtility.getUsernameParam(location.getUsername()) + " -N\n");
                        proxy.importTo(path, SVNUtility.encodeURL(url), CreateFileOperation.this.message, SVNDepth.FILES, 4352L, null, null, new SVNProgressMonitor(CreateFileOperation.this, monitor, null));
                    }
                }, monitor, this.fileNames.length);
                ++i;
            }
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }
}

