/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetLogMessagesOperation
extends AbstractRepositoryOperation {
    protected SVNLogEntry[] msg;
    protected SVNRevision startRevision;
    protected SVNRevision endRevision;
    protected long limit;
    protected boolean isRetryIfMergeInfoNotSupported;
    protected long options;

    public GetLogMessagesOperation(IRepositoryResource resource) {
        this(resource, false);
    }

    public GetLogMessagesOperation(IRepositoryResource resource, boolean stopOnCopy) {
        this(resource, 0x40000L | (stopOnCopy ? 131072L : 0L));
    }

    public GetLogMessagesOperation(IRepositoryResource resource, long options) {
        super("Operation_GetLogMessages", SVNMessages.class, new IRepositoryResource[]{resource});
        this.options = options & 0xE0000L;
        this.limit = 0L;
        this.endRevision = SVNRevision.fromNumber(0L);
    }

    public boolean getIncludeMerged() {
        return (this.options & 0x80000L) != 0L;
    }

    public void setIncludeMerged(boolean includeMerged) {
        this.options &= 0xFFFFFFFFFFF7FFFFL;
        this.options |= includeMerged ? 524288L : 0L;
    }

    public void setRetryIfMergeInfoNotSupported(boolean isRetryIfMergeInfoNotSupported) {
        this.isRetryIfMergeInfoNotSupported = isRetryIfMergeInfoNotSupported;
    }

    public boolean getStopOnCopy() {
        return (this.options & 0x20000L) != 0L;
    }

    public void setStopOnCopy(boolean stopOnCopy) {
        this.options &= 0xFFFFFFFFFFFDFFFFL;
        this.options |= stopOnCopy ? 131072L : 0L;
    }

    public boolean getDiscoverPaths() {
        return (this.options & 0x40000L) != 0L;
    }

    public void setDiscoverPaths(boolean discoverPaths) {
        this.options &= 0xFFFFFFFFFFFBFFFFL;
        this.options |= discoverPaths ? 262144L : 0L;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setStartRevision(SVNRevision revision) {
        this.startRevision = revision;
    }

    public void setEndRevision(SVNRevision revision) {
        this.endRevision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        block7: {
            IRepositoryResource resource = this.operableData()[0];
            if (this.startRevision == null) {
                this.startRevision = resource.getSelectedRevision();
            }
            IRepositoryLocation location = resource.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                try {
                    this.msg = SVNUtility.logEntries(proxy, SVNUtility.getEntryReference(resource), this.startRevision, this.endRevision, this.options, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, this.limit, new SVNProgressMonitor(this, monitor, null));
                }
                catch (SVNConnectorException ex) {
                    if (this.isRetryIfMergeInfoNotSupported && ex.getErrorId() == 200007 && (this.options & 0x80000L) != 0L) {
                        this.options &= 0xFFFFFFFFFFF7FFFFL;
                        this.msg = SVNUtility.logEntries(proxy, SVNUtility.getEntryReference(resource), this.startRevision, this.endRevision, this.options, ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, this.limit, new SVNProgressMonitor(this, monitor, null));
                        break block7;
                    }
                    throw ex;
                }
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
    }

    public SVNLogEntry[] getMessages() {
        return this.msg;
    }

    public IRepositoryResource getResource() {
        return this.operableData()[0];
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

