/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringMatcher {
    protected static final String NOT_MASKING = "^[a-zA-Z_0-9]$";
    protected Pattern filter;

    public StringMatcher(String mask) {
        this.filter = Pattern.compile(this.getRegexp(mask), 34);
    }

    protected String getRegexp(String pattern) {
        if (pattern.length() == 0) {
            return "\\s*";
        }
        Pattern regexp = Pattern.compile(NOT_MASKING);
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < pattern.length()) {
            String ch = pattern.substring(i, i + 1);
            Matcher matcher = regexp.matcher(ch);
            if (matcher.matches()) {
                ret.append(ch);
            } else if ("?".equals(ch)) {
                ret.append(".");
            } else if ("*".equals(ch)) {
                ret.append(".*");
            } else {
                ret.append("\\");
                ret.append(ch);
            }
            ++i;
        }
        return ret.toString();
    }

    public boolean match(String text) {
        return text != null && this.filter.matcher(text).matches();
    }
}

