/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.m2e;

import org.eclipse.m2e.scm.ScmUrl;
import org.eclipse.m2e.scm.spi.ScmHandlerUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.m2e.M2ESVNPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.panel.IDialogPanel;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.panel.common.SelectRevisionPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SVNScmHandlerUi
extends ScmHandlerUi {
    public boolean canSelectUrl() {
        return true;
    }

    public boolean canSelectRevision() {
        return true;
    }

    public ScmUrl selectUrl(Shell shell, ScmUrl scmUrl) {
        IRepositoryResource[] iRepositoryResourceArray;
        IRepositoryResource repositoryResource = this.getRepositoryResource(scmUrl);
        String string = M2ESVNPlugin.instance().getResource("CheckoutAsMavenProjectWizard.OptionsPage.Selection.Title");
        String string2 = M2ESVNPlugin.instance().getResource("CheckoutAsMavenProjectWizard.OptionsPage.Selection.Description");
        if (repositoryResource == null) {
            iRepositoryResourceArray = new IRepositoryResource[]{};
        } else {
            IRepositoryResource[] iRepositoryResourceArray2 = new IRepositoryResource[1];
            iRepositoryResourceArray = iRepositoryResourceArray2;
            iRepositoryResourceArray2[0] = repositoryResource;
        }
        RepositoryTreePanel panel = new RepositoryTreePanel(SVNUIMessages.RepositoryResourceSelectionComposite_Select_Title, string, string2, iRepositoryResourceArray, true, false);
        panel.setAllowFiles(false);
        DefaultDialog browser = new DefaultDialog(shell, (IDialogPanel)panel);
        if (browser.open() == 0) {
            IRepositoryResource selectedResource = panel.getSelectedResource();
            return new ScmUrl("scm:svn:" + selectedResource.getUrl());
        }
        return null;
    }

    public String selectRevision(Shell shell, ScmUrl scmUrl, String scmRevision) {
        IRepositoryResource repositoryResource = this.getRepositoryResource(scmUrl);
        if (repositoryResource == null) {
            return null;
        }
        GetLogMessagesOperation msgsOp = SelectRevisionPanel.getMsgsOp((IRepositoryResource)repositoryResource, (boolean)true);
        if (!UIMonitorUtility.doTaskNowDefault((Shell)shell, (IActionOperation)msgsOp, (boolean)true).isCancelled() && msgsOp.getExecutionState() == 0) {
            SelectRevisionPanel panel;
            DefaultDialog dialog;
            long currentRevision = -1L;
            try {
                SVNRevision rev;
                if (scmRevision != null && scmRevision.length() > 0 && (rev = SVNRevision.fromString((String)scmRevision)).getKind() == SVNRevision.Kind.NUMBER) {
                    currentRevision = ((SVNRevision.Number)rev).getNumber();
                }
            }
            catch (IllegalArgumentException ex) {
                UILoggedOperation.reportError((String)"SVNScmHandlerUi.selectRevision", (Throwable)ex);
            }
            if ((dialog = new DefaultDialog(shell, (IDialogPanel)(panel = new SelectRevisionPanel(msgsOp, false, false, currentRevision)))).open() == 0) {
                long selectedRevisionNum = panel.getSelectedRevision();
                return Long.toString(selectedRevisionNum);
            }
        }
        return null;
    }

    private IRepositoryResource getRepositoryResource(ScmUrl scmUrl) {
        if (scmUrl == null) {
            return null;
        }
        String url = scmUrl.getUrl();
        if (url.startsWith("scm:svn:")) {
            url = scmUrl.getUrl().substring("scm:svn:".length());
        }
        return SVNUtility.asRepositoryResource((String)url, (boolean)true);
    }

    public boolean isValidUrl(String scmUrl) {
        return scmUrl != null && scmUrl.startsWith("scm:svn:") && SVNUtility.isValidSVNURL((String)scmUrl.substring("scm:svn:".length()));
    }

    public boolean isValidRevision(ScmUrl scmUrl, String scmRevision) {
        try {
            SVNRevision revision = SVNRevision.fromString((String)scmRevision);
            SVNRevision.Kind kind = revision.getKind();
            return kind == SVNRevision.Kind.HEAD || kind == SVNRevision.Kind.NUMBER;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

