/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.team.svn.core.resource.IRepositoryBase;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IRepositoryContentFilter;
import org.eclipse.team.svn.ui.repository.model.RepositoriesRoot;
import org.eclipse.team.svn.ui.repository.model.RepositoryContentProvider;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;

public class RepositoryTreeComposite
extends Composite {
    protected RepositoryTreeViewer repositoryTree;
    protected DrillDownAdapter ddAdapter;
    protected RepositoryContentProvider provider;
    protected boolean autoExpandFirstLevel;

    public RepositoryTreeComposite(Composite parent, int style) {
        this(parent, style, false);
    }

    public RepositoryTreeComposite(Composite parent, int style, boolean multiSelect) {
        this(parent, style, multiSelect, new RepositoriesRoot());
    }

    public RepositoryTreeComposite(Composite parent, int style, boolean multiSelect, Object input) {
        super(parent, style);
        this.createControls(multiSelect ? 2 : 4, input);
    }

    public RepositoryTreeViewer getRepositoryTreeViewer() {
        return this.repositoryTree;
    }

    public void setAutoExpandFirstLevel(boolean autoExpandFirstLevel) {
        this.autoExpandFirstLevel = autoExpandFirstLevel;
    }

    public Object getModelRoot() {
        return this.repositoryTree.getInput();
    }

    public void setModelRoot(Object root) {
        if (root instanceof IRepositoryLocation) {
            this.repositoryTree.setInput(new RepositoryLocation((IRepositoryLocation)root));
        } else if (root instanceof IRepositoryBase) {
            RepositoryResource resource = RepositoryFolder.wrapChild(null, (IRepositoryResource)root, null);
            resource.setViewer(this.repositoryTree);
            this.repositoryTree.setInput(resource);
        } else {
            this.repositoryTree.setInput(root);
        }
    }

    public IRepositoryContentFilter getFilter() {
        return this.provider.getFilter();
    }

    public void setFilter(IRepositoryContentFilter filter) {
        this.provider.setFilter(filter);
        this.repositoryTree.refresh();
    }

    private void createControls(int style, Object input) {
        GridData data = null;
        GridLayout layout = null;
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl((Composite)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        toolBar.setLayoutData((Object)data);
        this.repositoryTree = new RepositoryTreeViewer(this, style | 0x100 | 0x200);
        if (this.autoExpandFirstLevel) {
            this.repositoryTree.setAutoExpandLevel(2);
        }
        this.repositoryTree.getTree().setLayoutData((Object)new GridData(1808));
        this.provider = new RepositoryContentProvider(this.repositoryTree);
        this.repositoryTree.setContentProvider((IContentProvider)this.provider);
        this.repositoryTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.setModelRoot(input);
        this.repositoryTree.setAutoExpandLevel(2);
        this.ddAdapter = new DrillDownAdapter((TreeViewer)this.repositoryTree);
        this.ddAdapter.addNavigationActions((IToolBarManager)toolBarMgr);
        toolBarMgr.update(true);
    }
}

