/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class CComboSelectionRule
extends GenerationRule {
    private Combo combo;
    private String newSelection;
    private int newSelectionIndex;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Combo && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        this.combo = (Combo)event.widget;
        this.newSelection = this.combo.getText();
        this.newSelectionIndex = this.combo.getSelectionIndex();
    }

    protected String getWidgetAccessor() {
        int index = WidgetUtils.getIndex((Control)this.combo);
        if (index != 0) {
            return "bot.combo(" + index + ")";
        }
        return "bot.combo()";
    }

    protected String getActon() {
        StringBuilder res = new StringBuilder();
        res.append(".select(");
        if (this.newSelection != null) {
            res.append('\"');
            res.append(this.newSelection);
            res.append("\")");
        } else {
            res.append(this.newSelectionIndex);
            res.append(")");
        }
        return res.toString();
    }
}

