/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor.document;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.generator.framework.AnnotationRule;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.jdt.editor.document.Method;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDocument
extends Document {
    private Set<String> imports;
    private List<Method> methods;
    private int lastOffset;
    private List<AnnotationRule> classAnnotations;
    private SourceViewer viewer;

    public ClassDocument(String className) {
        this.set("\npublic class " + className + "{\n\n}");
        this.imports = new HashSet<String>();
        this.methods = new ArrayList<Method>();
        this.classAnnotations = new ArrayList<AnnotationRule>();
    }

    public void addGenerationRule(GenerationRule rule) {
        List codes = rule.getActions();
        if (this.getActiveMethod() == null) {
            return;
        }
        int offset = this.imports.size() + 4 + this.classAnnotations.size();
        offset += this.computeOffsetUntilActiveIsMet();
        offset += this.computeActiveMethodOffset();
        ArrayList<String> text = new ArrayList<String>();
        for (String code : codes) {
            text.add("\t\t" + code + ";\n");
        }
        this.getActiveMethod().addCode(rule);
        this.addText(offset, text);
        if (rule.getImports() != null) {
            for (String im : rule.getImports()) {
                this.addImport(im);
            }
        }
    }

    private void addText(int offset, List<String> text) {
        MultiTextEdit edit = new MultiTextEdit();
        try {
            for (String t : text) {
                edit.addChild((TextEdit)new InsertEdit(this.getLineOffset(offset), t));
            }
            edit.apply((IDocument)this);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.updateColoring();
    }

    private void removeText(int offset) {
        MultiTextEdit edit = new MultiTextEdit();
        try {
            edit.addChild((TextEdit)new DeleteEdit(this.getLineOffset(offset), this.getLineLength(offset)));
            edit.apply((IDocument)this);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.updateColoring();
    }

    public void addMethod(String methodName) {
        int offset = this.imports.size() + 3;
        offset += this.classAnnotations.size();
        for (Method m : this.methods) {
            offset = offset + m.getAllLinesSize() + 3;
            offset += m.getAnnotations().size();
        }
        Method method = new Method(methodName);
        this.methods.add(method);
        ArrayList<String> text = new ArrayList<String>();
        text.add("\tpublic void " + methodName + "(){" + "\n");
        text.add("\t}\n\n");
        this.addText(offset, text);
        this.setActiveMethod(methodName);
    }

    private void addImport(String importCode) {
        if (this.imports.add(importCode)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("import " + importCode + ";\n");
            this.addText(this.imports.size() - 1, text);
        }
    }

    private void removeImport(String importCode) {
        if (this.imports.contains(importCode)) {
            String[] lines = this.get().split("\n");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].contains(importCode)) {
                    this.imports.remove(importCode);
                    this.removeText(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void setActiveMethod(String methodName) {
        this.getActiveMethod().setActive(false);
        for (Method m : this.methods) {
            if (!m.getName().equals(methodName)) continue;
            m.setActive(true);
        }
        this.updateColoring();
    }

    public void removeAnnotation(AnnotationRule rule) {
        int offset = this.imports.size() + 3 + this.classAnnotations.size();
        offset += this.computeOffsetUntilActiveIsMet();
        offset = offset + this.getActiveMethod().getAnnotations().size() - this.getActiveMethod().getAnnotations().indexOf(rule) - 1;
        if (this.getActiveMethod().removeAnnotation(rule)) {
            this.removeText(offset);
            if (!this.isAnnotationPresent(rule)) {
                this.removeImport(rule.getImportText());
            }
        }
    }

    public void removeClassAnnotation(AnnotationRule rule) {
        if (this.classAnnotations.contains(rule)) {
            int offset = this.imports.size() + 1 + this.classAnnotations.indexOf(rule);
            this.removeText(offset);
            this.classAnnotations.remove(rule);
            if (!this.isAnnotationPresent(rule)) {
                this.removeImport(rule.getImportText());
            }
        }
    }

    public void addClassAnnotation(AnnotationRule rule) {
        this.addImport(rule.getImportText());
        int offset = this.imports.size() + 1 + this.classAnnotations.size();
        ArrayList<String> text = new ArrayList<String>();
        text.add("@" + rule.getAnnotation() + "\n");
        this.classAnnotations.add(rule);
        this.addText(offset, text);
    }

    public void addAnnotation(AnnotationRule rule) {
        int offset = this.computeOffsetUntilActiveIsMet();
        this.getActiveMethod().addAnnotation(rule);
        this.addImport(rule.getImportText());
        offset = offset + this.imports.size() + 3 + this.classAnnotations.size();
        ArrayList<String> text = new ArrayList<String>();
        text.add("\t@" + rule.getAnnotation() + "\n");
        this.addText(offset, text);
    }

    public Method getActiveMethod() {
        for (Method m : this.methods) {
            if (!m.isActive()) continue;
            return m;
        }
        return null;
    }

    public int getLastOffset() {
        return this.lastOffset;
    }

    private void setLastOffset(int lastOffset) {
        this.lastOffset = lastOffset;
    }

    public List<AnnotationRule> getClassAnnotations() {
        return this.classAnnotations;
    }

    private boolean isAnnotationPresent(AnnotationRule rule) {
        if (this.classAnnotations.contains(rule)) {
            return true;
        }
        for (Method m : this.methods) {
            for (AnnotationRule r : m.getAnnotations()) {
                if (!r.equals((Object)rule)) continue;
                return true;
            }
        }
        return false;
    }

    private int getMethodLinesB() {
        int i = 0;
        int methodLinesB = this.imports.size() + 3 + this.classAnnotations.size();
        Method activeMethod = this.methods.get(i);
        while (!activeMethod.isActive()) {
            methodLinesB = methodLinesB + activeMethod.getAllLinesSize() + 3;
            methodLinesB += activeMethod.getAnnotations().size();
            activeMethod = this.methods.get(++i);
        }
        return methodLinesB;
    }

    private void updateColoring() {
        if (this.viewer != null && this.getActiveMethod() != null) {
            this.viewer.getTextWidget().setLineBackground(0, this.viewer.getTextWidget().getLineCount(), this.viewer.getTextWidget().getLineBackground(0));
            Color orange = new Color((Device)Display.getCurrent(), 205, 205, 201);
            int methodsCodeSize = this.getActiveMethod().getAllLinesSize();
            this.viewer.getTextWidget().setLineBackground(this.getMethodLinesB(), this.getActiveMethod().getAnnotations().size() + methodsCodeSize + 2, orange);
            this.setLastOffset(this.getMethodLinesB() + this.getActiveMethod().getAnnotations().size() + methodsCodeSize);
        }
    }

    private int computeOffsetUntilActiveIsMet() {
        int i = 0;
        int offset = 0;
        Method activeMethod = this.methods.get(i);
        while (!activeMethod.isActive()) {
            offset = offset + activeMethod.getAllLinesSize() + 3;
            offset += activeMethod.getAnnotations().size();
            activeMethod = this.methods.get(++i);
        }
        return offset;
    }

    private int computeActiveMethodOffset() {
        return this.getActiveMethod().getAllLinesSize() + this.getActiveMethod().getAnnotations().size();
    }

    public void setViewer(SourceViewer generatedCode) {
        this.viewer = generatedCode;
    }

    public List<Method> getMethods() {
        return this.methods;
    }
}

