/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellMenuClickedRule
extends GenerationSimpleRule {
    private List<String> path;

    @Override
    public boolean appliesTo(Event event) {
        boolean menu = event.widget instanceof MenuItem;
        int style = 0;
        if (menu) {
            MenuItem currentItem = (MenuItem)event.widget;
            Menu parent = null;
            while (currentItem != null && (parent = currentItem.getParent()) != null) {
                style = parent.getStyle();
                currentItem = parent.getParentItem();
            }
        }
        return event.type == 13 && menu && (style & 2) != 0;
    }

    @Override
    public void initializeForEvent(Event event) {
        MenuItem item = (MenuItem)event.widget;
        this.path = new ArrayList<String>();
        this.path.add(item.getText());
        MenuItem currentItem = item;
        Menu parent = null;
        while (currentItem != null && (parent = currentItem.getParent()) != null) {
            currentItem = parent.getParentItem();
            if (currentItem == null || currentItem.getText() == null) continue;
            this.path.add(currentItem.getText());
        }
        Collections.reverse(this.path);
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        code.append("bot");
        for (String text : this.path) {
            code.append(".menu(\"");
            code.append(WidgetUtils.cleanText(text));
            code.append("\")");
        }
        code.append(".click()");
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }
}

