/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.e4.finder.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swtbot.e4.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.e4.finder.waits.Conditions;
import org.eclipse.swtbot.e4.finder.waits.WaitForPart;
import org.eclipse.swtbot.e4.finder.widgets.SWTBotPerspective;
import org.eclipse.swtbot.e4.finder.widgets.SWTBotView;
import org.eclipse.swtbot.e4.finder.widgets.WorkbenchContentsFinder;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTWorkbenchBot
extends SWTBot {
    private final IEclipseContext context;
    private final WorkbenchContentsFinder workbenchContentsFinder;

    public SWTWorkbenchBot(IEclipseContext context) {
        this.context = context;
        this.workbenchContentsFinder = new WorkbenchContentsFinder(context);
        this.waitUntil((ICondition)new IEclipseContextReady());
    }

    public SWTBotPerspective perspective(Matcher<?> matcher) {
        List<MPerspective> perspectives = this.workbenchContentsFinder.findPerspectives(matcher);
        return new SWTBotPerspective(perspectives.get(0), this);
    }

    public SWTBotPerspective perspectiveByLabel(String label) {
        return this.perspective(WidgetMatcherFactory.withPerspectiveLabel(label));
    }

    public SWTBotPerspective perspectiveById(String id) {
        return this.perspective(WidgetMatcherFactory.withPerspectiveId(id));
    }

    public List<SWTBotPerspective> perspectives(Matcher<?> matcher) {
        List<MPerspective> perspectives = this.workbenchContentsFinder.findPerspectives(matcher);
        ArrayList<SWTBotPerspective> perspectiveBots = new ArrayList<SWTBotPerspective>();
        for (MPerspective perspective : perspectives) {
            perspectiveBots.add(new SWTBotPerspective(perspective, this));
        }
        return perspectiveBots;
    }

    public List<SWTBotPerspective> perspectives() {
        return this.perspectives(Matchers.anything());
    }

    public SWTBotPerspective activePerspective() {
        MPerspective perspective = this.workbenchContentsFinder.findActivePerspective();
        if (perspective == null) {
            throw new WidgetNotFoundException("There is no active perspective");
        }
        return new SWTBotPerspective(perspective, this);
    }

    public void switchPerspective(final MPerspective perspective) {
        this.waitUntil((ICondition)new IEclipseContextReady());
        final EPartService partService = (EPartService)this.context.get(EPartService.class);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                partService.switchPerspective(perspective);
            }
        });
    }

    public SWTBotView part(Matcher<MPart> matcher) {
        WaitForPart waitForPart = Conditions.waitForPart(this.context, matcher);
        this.waitUntilWidgetAppears((ICondition)waitForPart);
        return new SWTBotView((MPart)waitForPart.get(0), this);
    }

    public SWTBotView partByTitle(String title) {
        Matcher withPartName = WidgetMatcherFactory.withPartName(title);
        return this.part(withPartName);
    }

    public SWTBotView partById(String id) {
        Matcher withPartId = WidgetMatcherFactory.withPartId(id);
        return this.part(withPartId);
    }

    public List<SWTBotView> parts(Matcher<?> matcher) {
        List<MPart> parts = this.workbenchContentsFinder.findParts(matcher);
        ArrayList<SWTBotView> partBots = new ArrayList<SWTBotView>();
        for (MPart part : parts) {
            partBots.add(new SWTBotView(part, this));
        }
        return partBots;
    }

    public boolean isPartActive(final MPart part) {
        final EPartService partService = (EPartService)this.context.get(EPartService.class);
        return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                if (partService.getActivePart() == part) {
                    return true;
                }
                return false;
            }
        });
    }

    public List<SWTBotView> parts() {
        return this.parts(Matchers.anything());
    }

    public SWTBotView activePart() {
        MPart part = this.workbenchContentsFinder.findActivePart();
        if (part == null) {
            throw new WidgetNotFoundException("There is no active part");
        }
        return new SWTBotView(part, this);
    }

    public void showPart(final MPart part) {
        this.waitUntil((ICondition)new IEclipseContextReady());
        final EPartService partService = (EPartService)this.context.get(EPartService.class);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                partService.showPart(part, EPartService.PartState.ACTIVATE);
            }
        });
    }

    public void closePart(final MPart part) {
        this.waitUntil((ICondition)new IEclipseContextReady());
        final EPartService partService = (EPartService)this.context.get(EPartService.class);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                if (partService.savePart(part, true)) {
                    partService.hidePart(part);
                }
            }
        });
    }

    public SWTBotShell activeShell() throws WidgetNotFoundException {
        SWTBotShell swtBotShell = super.activeShell();
        if (swtBotShell.getText().equals("PartRenderingEngine's limbo")) {
            throw new WidgetNotFoundException("The activeShell() returned was the Limbo shell. This is most likely NOT the shell you were expecting!");
        }
        return swtBotShell;
    }

    protected IEclipseContext getContext() {
        return this.context;
    }

    protected class IEclipseContextReady
    extends DefaultCondition {
        protected IEclipseContextReady() {
        }

        public boolean test() throws Exception {
            return SWTWorkbenchBot.this.context.getActiveChild() != null;
        }

        public String getFailureMessage() {
            return "The current context does not contain an active window as its activeChild()";
        }
    }
}

