/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.swt.finder.junit5;

import java.util.Optional;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWTBotJunit5Extension
implements TestWatcher {
    private static Logger log = LoggerFactory.getLogger(SWTBot.class);
    private static int screenshotCounter = 0;

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.captureScreenshot(context);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
    }

    public void testSuccessful(ExtensionContext context) {
    }

    public void captureScreenshot(ExtensionContext context) {
        try {
            int maximumScreenshots = SWTBotPreferences.MAX_ERROR_SCREENSHOT_COUNT;
            String fileName = this.getFileName(context);
            if (++screenshotCounter <= maximumScreenshots) {
                this.captureScreenshot(fileName);
            } else {
                log.info("No screenshot captured for '" + context.getTestClass() + "." + context.getTestMethod() + "' because maximum number of screenshots reached: " + maximumScreenshots);
            }
        }
        catch (Exception e) {
            log.warn("Could not capture screenshot", (Throwable)e);
        }
    }

    private String getFileName(ExtensionContext context) {
        return String.valueOf(SWTBotPreferences.SCREENSHOTS_DIR) + "/" + context.getRequiredTestClass().getName() + "." + context.getRequiredTestMethod().getName() + "." + SWTBotPreferences.SCREENSHOT_FORMAT.toLowerCase();
    }

    private boolean captureScreenshot(String fileName) {
        return SWTUtils.captureScreenshot((String)fileName);
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

