/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.movida.DynamicVSMLoader;
import org.eclipse.sirius.ext.base.relations.Relation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

class VSMRequirementChangeAdapter
extends EContentAdapter {
    private final Resource resource;
    private final DynamicVSMLoader loader;
    private final Multimap<URI, Viewpoint> requirements = HashMultimap.create();

    VSMRequirementChangeAdapter(Resource res, DynamicVSMLoader loader) {
        this.resource = res;
        this.loader = loader;
    }

    public void install() {
        Relation requires = this.loader.getRegistry().getRelations().getRequires();
        ViewpointResourceHandler handler = this.loader.getRegistry().getSiriusResourceHandler();
        for (Viewpoint vp : handler.collectViewpointDefinitions(this.resource)) {
            for (URI required : requires.apply((Object)((URI)new ViewpointQuery(vp).getViewpointURI().get()))) {
                this.addRequirement(required, vp);
            }
        }
        this.resource.eAdapters().add((Object)this);
    }

    public void uninstall() {
        this.resource.eAdapters().remove((Object)this);
    }

    public void notifyChanged(Notification notification) {
        block16: {
            Object feature;
            block15: {
                super.notifyChanged(notification);
                feature = notification.getFeature();
                if ((!(notification.getNotifier() instanceof Viewpoint) || feature != DescriptionPackage.eINSTANCE.getViewpoint_Customizes()) && feature != DescriptionPackage.eINSTANCE.getViewpoint_Reuses()) break block15;
                switch (notification.getEventType()) {
                    case 3: 
                    case 5: {
                        Object added = notification.getNewValue();
                        if (added instanceof List) {
                            this.handleRequirementsAdded((Viewpoint)notification.getNotifier(), Iterables.filter((Iterable)((List)added), URI.class));
                            break;
                        }
                        if (added instanceof URI) {
                            this.handleRequirementsAdded((Viewpoint)notification.getNotifier(), Collections.singleton((URI)added));
                            break;
                        }
                        break block16;
                    }
                    case 4: 
                    case 6: {
                        Object removed = notification.getOldValue();
                        if (removed instanceof List) {
                            this.handleRequirementsRemoved((Viewpoint)notification.getNotifier(), Iterables.filter((Iterable)((List)removed), URI.class));
                            break;
                        }
                        if (removed instanceof URI) {
                            this.handleRequirementsRemoved((Viewpoint)notification.getNotifier(), Collections.singleton((URI)removed));
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (notification.getNotifier() instanceof Group && feature == DescriptionPackage.eINSTANCE.getGroup_OwnedViewpoints()) {
                switch (notification.getEventType()) {
                    case 3: 
                    case 5: {
                        Object added = notification.getNewValue();
                        if (added instanceof List) {
                            this.handleViewpointsAdded(Iterables.filter((Iterable)((List)added), Viewpoint.class));
                            break;
                        }
                        if (!(added instanceof Viewpoint)) break;
                        this.handleViewpointsAdded(Collections.singleton((Viewpoint)added));
                        break;
                    }
                    case 4: 
                    case 6: {
                        Object removed = notification.getOldValue();
                        if (removed instanceof List) {
                            this.handleViewpointsRemoved(Iterables.filter((Iterable)((List)removed), Viewpoint.class));
                            break;
                        }
                        if (!(removed instanceof Viewpoint)) break;
                        this.handleViewpointsRemoved(Collections.singleton((Viewpoint)removed));
                        break;
                    }
                }
            }
        }
    }

    private void addRequirement(URI required, Viewpoint vp) {
        boolean wasNotRequired = this.requirements.get((Object)required).isEmpty();
        this.requirements.put((Object)required, (Object)vp);
        if (wasNotRequired) {
            this.loader.require(required);
        }
    }

    private void removeRequirement(URI required, Viewpoint vp) {
        boolean removed = this.requirements.remove((Object)required, (Object)vp);
        if (removed && this.requirements.get((Object)required).isEmpty()) {
            this.loader.unrequire(required);
        }
    }

    private void handleRequirementsAdded(Viewpoint vp, Iterable<URI> added) {
        for (URI uri : added) {
            this.addRequirement(uri, vp);
        }
    }

    private void handleRequirementsRemoved(Viewpoint vp, Iterable<URI> removed) {
        for (URI uri : removed) {
            this.removeRequirement(uri, vp);
        }
    }

    private void handleViewpointsAdded(Iterable<Viewpoint> added) {
        Relation requires = this.loader.getRegistry().getRelations().getRequires();
        for (Viewpoint viewpoint : added) {
            for (URI uri : requires.apply((Object)((URI)new ViewpointQuery(viewpoint).getViewpointURI().get()))) {
                this.addRequirement(uri, viewpoint);
            }
        }
    }

    private void handleViewpointsRemoved(Iterable<Viewpoint> removed) {
        for (Viewpoint viewpoint : removed) {
            for (URI uri : this.requirements.keySet()) {
                this.removeRequirement(uri, viewpoint);
            }
        }
    }
}

