/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp.impl;

import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.polarsys.time4sys.marte.nfp.Dimension;
import org.polarsys.time4sys.marte.nfp.ValueWithUnit;

public abstract class AbstractRealWithUnitValueImpl<U extends Enumerator, T extends ValueWithUnit<U>>
extends MinimalEObjectImpl.Container
implements ValueWithUnit<U> {
    protected final Dimension<U> d;

    public AbstractRealWithUnitValueImpl(Dimension<U> dimension) {
        this.d = dimension;
    }

    @Override
    public abstract U getUnit();

    @Override
    public abstract double getValue();

    protected abstract T create(double var1, U var3);

    public T add(T v) {
        U targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
        T v1 = this.convertToUnit(targetUnit);
        T v2 = this.convertToUnit(v, targetUnit);
        return this.create(v1.getValue() + v2.getValue(), targetUnit);
    }

    public T convertToUnit(U target) {
        return (T)this.convertToUnit(this, target);
    }

    private T convertToUnit(T v, U target) {
        if (v.getUnit() == target) {
            return v;
        }
        return this.create(v.getValue() * this.d.getConversionFactor(v.getUnit(), target), target);
    }

    public T simplify() {
        AbstractRealWithUnitValueImpl<U, T> result = this;
        for (Enumerator u : this.d.getValues().subList(this.getUnit().getValue(), this.d.getValues().size())) {
            T r = this.convertToUnit(u);
            if (r.getValue() <= 1.0) break;
            result = r;
        }
        if (result.getValue() >= 1.0 || result.getUnit() == this.d.getLowestUnit()) {
            return (T)result;
        }
        ArrayList<U> du = new ArrayList<U>(this.d.getValues().subList(0, this.getUnit().getValue()));
        Collections.reverse(du);
        for (Enumerator u : du) {
            T r = this.convertToUnit(u);
            if (!this.isInteger(r.getValue())) continue;
            result = r;
            break;
        }
        return (T)result;
    }

    public T sub(T v) {
        U targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
        T v1 = this.convertToUnit(targetUnit);
        T v2 = this.convertToUnit(v, targetUnit);
        return this.create(v1.getValue() - v2.getValue(), targetUnit);
    }

    public int compareTo(T anotherT) {
        U targetUnit = this.d.findClosestUnitTo(this.getUnit(), anotherT.getUnit());
        T v1 = this.convertToUnit(targetUnit);
        T v2 = this.convertToUnit(anotherT, targetUnit);
        return Double.compare(v1.getValue(), v2.getValue());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
        long temp = Double.doubleToLongBits(this.getValue());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractRealWithUnitValueImpl)) {
            return false;
        }
        AbstractRealWithUnitValueImpl other = (AbstractRealWithUnitValueImpl)obj;
        if (this.getUnit() == other.getUnit()) {
            return Double.doubleToLongBits(this.getValue()) == Double.doubleToLongBits(other.getValue());
        }
        if (this.isZero() && other.isZero()) {
            return true;
        }
        U target = this.d.findClosestUnitTo(this.getUnit(), other.getUnit());
        return this.convertToUnit(target).equals(other.convertToUnit(target));
    }

    public boolean isZero() {
        return Double.doubleToLongBits(this.getValue()) == 0L;
    }

    public boolean notZero() {
        return !this.isZero();
    }

    private boolean isInteger(double v) {
        return v == Math.floor(v) && !Double.isInfinite(v);
    }

    public T max(T other) {
        if (other == null) {
            return (T)this;
        }
        if (this.getUnit() == other.getUnit()) {
            if (this.getValue() >= other.getValue()) {
                return (T)this;
            }
            return other;
        }
        U target = this.d.findClosestUnitTo(this.getUnit(), other.getUnit());
        if (this.convertToUnit(target).getValue() >= this.convertToUnit(other, target).getValue()) {
            return (T)this;
        }
        return other;
    }

    public T min(T other) {
        if (other == null) {
            return (T)this;
        }
        if (this.getUnit() == other.getUnit()) {
            if (this.getValue() <= other.getValue()) {
                return (T)this;
            }
            return other;
        }
        U target = this.d.findClosestUnitTo(this.getUnit(), other.getUnit());
        if (this.convertToUnit(target).getValue() <= this.convertToUnit(other, target).getValue()) {
            return (T)this;
        }
        return other;
    }

    public T multiply(long v) {
        return this.create(this.getValue() * (double)v, this.getUnit());
    }

    public T lcm(T v) {
        U targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
        T v1 = this.convertToUnit(targetUnit);
        T v2 = this.convertToUnit(v, targetUnit);
        return this.create(this.lcm(v1.getValue(), v2.getValue(), 1.0E-7), targetUnit);
    }

    private double lcm(double m, double n, double epsilon) {
        if (Math.abs(m) < epsilon || Math.abs(n) < epsilon) {
            return 0.0;
        }
        return m * n / this.gcd(m, n, epsilon);
    }

    private double gcd(double m, double n, double epsilon) {
        while (Math.abs(n) > epsilon) {
            double q = m;
            m = n;
            n = q % n;
        }
        return m;
    }

    public double div(T v) {
        U targetUnit = this.d.findClosestUnitTo(this.getUnit(), v.getUnit());
        T v1 = this.convertToUnit(targetUnit);
        T v2 = this.convertToUnit(v, targetUnit);
        return v1.getValue() / v2.getValue();
    }

    public double div(T v, MathContext mc) {
        return this.div(v);
    }

    public long divide(T v) {
        return (long)this.div(v);
    }
}

