/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.srm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterruptKind implements Enumerator
{
    HARDWARE_INTERRUPTION(0, "HardwareInterruption", "HardwareInterruption"),
    PROCESSOR_DETECTED_EXCEPTION(1, "ProcessorDetectedException", "ProcessorDetectedException"),
    PROGRAMMED_EXCEPTION(2, "ProgrammedException", "ProgrammedException"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int HARDWARE_INTERRUPTION_VALUE = 0;
    public static final int PROCESSOR_DETECTED_EXCEPTION_VALUE = 1;
    public static final int PROGRAMMED_EXCEPTION_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final InterruptKind[] VALUES_ARRAY;
    public static final List<InterruptKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InterruptKind[]{HARDWARE_INTERRUPTION, PROCESSOR_DETECTED_EXCEPTION, PROGRAMMED_EXCEPTION, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InterruptKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterruptKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterruptKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterruptKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterruptKind get(int value) {
        switch (value) {
            case 0: {
                return HARDWARE_INTERRUPTION;
            }
            case 1: {
                return PROCESSOR_DETECTED_EXCEPTION;
            }
            case 2: {
                return PROGRAMMED_EXCEPTION;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private InterruptKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

