/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.List;
import org.polarsys.time4sys.builder.design.AlarmBuilder;
import org.polarsys.time4sys.builder.design.CommunicationChannelBuilder;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.InputPinBuilder;
import org.polarsys.time4sys.builder.design.OutputPinBuilder;
import org.polarsys.time4sys.builder.design.ReferenceBuilder;
import org.polarsys.time4sys.builder.design.SchedulableResourceBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.builder.design.WorkloadEventBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.ArrivalPattern;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.gqam.InputPin;
import org.polarsys.time4sys.marte.gqam.OutputPin;
import org.polarsys.time4sys.marte.gqam.PeriodicPattern;
import org.polarsys.time4sys.marte.gqam.PrecedenceRelation;
import org.polarsys.time4sys.marte.gqam.Reference;
import org.polarsys.time4sys.marte.gqam.ResourceServiceExcecution;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class StepBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private SchedulableResourceBuilder<?, ?> task;
    private DesignBuilder design;
    private Step step;
    private String deadline;
    private boolean isResourceServiceExecution = false;
    private AlarmBuilder reset;
    private AlarmBuilder activatedBy;
    private int reentrantBuild = 0;
    private String name;
    private Boolean isAtomic = null;

    public static StepBuilder aStep(DesignBuilder designBuilder) {
        return new StepBuilder(designBuilder, null);
    }

    public static StepBuilder aResourceServiceExcecution(DesignBuilder designBuilder) {
        return new StepBuilder(designBuilder, null).isResourceServiceExecution();
    }

    public StepBuilder(DesignBuilder designBuilder, SchedulableResourceBuilder<?, ?> taskBuilder) {
        assert (designBuilder != null);
        this.task = taskBuilder;
        this.design = designBuilder;
        this.step = null;
    }

    public StepBuilder(DesignBuilder designBuilder, SchedulableResourceBuilder<?, ?> taskBuilder, Step raw) {
        assert (designBuilder != null);
        assert (raw != null);
        this.task = taskBuilder;
        this.design = designBuilder;
        this.step = raw;
    }

    public StepBuilder(DesignBuilder designBuilder, Step raw) {
        assert (designBuilder != null);
        assert (raw != null);
        this.design = designBuilder;
        this.step = raw;
        this.task = new TaskBuilder(designBuilder, (SoftwareSchedulableResource)this.step.getConcurRes());
    }

    public Step build() {
        if (this.step == null) {
            this.step = this.createRawStep();
        }
        if (this.name != null) {
            this.step.setName(this.name);
        }
        if (!this.design.getMainScenario().getSteps().contains((Object)this.step)) {
            this.design.getMainScenario().getSteps().add((Object)this.step);
        }
        if (this.reentrantBuild > 2) {
            return this.step;
        }
        ++this.reentrantBuild;
        if (this.task != null) {
            this.step.setConcurRes(this.task.build(this.design));
        }
        if (this.step instanceof ResourceServiceExcecution) {
            ResourceServiceExcecution resExec = (ResourceServiceExcecution)this.step;
            if (this.reset != null) {
                resExec.setResourceService(this.reset.buildResetService(this.design));
            }
            if (this.activatedBy != null) {
                resExec.setResourceService(this.activatedBy.buildSignalService(this.design));
            }
        }
        if (this.isAtomic != null) {
            this.step.setIsAtomic(this.isAtomic.booleanValue());
        }
        --this.reentrantBuild;
        return this.step;
    }

    public Step createRawStep() {
        if (this.isResourceServiceExecution) {
            return gqamFactory.createResourceServiceExcecution();
        }
        return gqamFactory.createExecutionStep();
    }

    private StepBuilder isResourceServiceExecution() {
        this.isResourceServiceExecution = true;
        return this;
    }

    public StepBuilder ofWCET(String wcet) {
        this.build().setWorstCET(nfpFactory.createDurationFromString(wcet));
        return this;
    }

    public StepBuilder ofBCET(String bcet) {
        this.build().setBestCET(nfpFactory.createDurationFromString(bcet));
        return this;
    }

    public StepBuilder isFollowedByAStep() {
        StepBuilder res = new StepBuilder(this.design, this.task);
        this.activates(res);
        return res;
    }

    private PrecedenceRelation getOutputRel() {
        PrecedenceRelation res = this.build().getOutputRel();
        if (res == null) {
            res = this.design.hasAPrecedenceRelation().build();
            this.step.setOutputRel(res);
        }
        return res;
    }

    public TaskBuilder getTask() {
        return (TaskBuilder)this.task;
    }

    public CommunicationChannelBuilder getChannel() {
        return (CommunicationChannelBuilder)this.task;
    }

    public void setConcurRes(SchedulableResourceBuilder<?, ?> task) {
        assert (task != null);
        this.task = task;
        if (this.step != null) {
            this.step.setConcurRes(task.build(this.design));
        }
    }

    public void setChannel(CommunicationChannelBuilder task) {
        this.setConcurRes(task);
    }

    public void setTask(TaskBuilder task) {
        this.setConcurRes(task);
        if (this.deadline != null) {
            task.ofDeadline(this.deadline);
        }
    }

    public StepBuilder called(String value) {
        this.name = value;
        return this;
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.step != null) {
            return this.step.getName();
        }
        return this.name;
    }

    protected WorkloadEventBuilder getWorkloadEvent() {
        if (this.step.getCause().isEmpty()) {
            throw new IllegalArgumentException("");
        }
        WorkloadEventBuilder cause = new WorkloadEventBuilder(this.design, (WorkloadEvent)this.step.getCause().get(0));
        return cause;
    }

    public StepBuilder isPeriodic(String period) {
        if (this.step == null) {
            this.build();
        }
        if (this.step.getCause().isEmpty()) {
            this.design.hasAPeriodicEvent(period).forStep(this.step).build();
        } else {
            WorkloadEvent cfr_ignored_0 = (WorkloadEvent)this.step.getCause().get(0);
        }
        return this;
    }

    public Duration getPeriod() {
        if (this.step == null) {
            this.build();
        }
        if (this.step.getCause() == null || this.step.getCause().isEmpty()) {
            throw new IllegalStateException("This task has no cause");
        }
        WorkloadEvent evt = (WorkloadEvent)this.step.getCause().get(0);
        ArrivalPattern pattern = evt.getPattern();
        if (pattern instanceof PeriodicPattern) {
            return ((PeriodicPattern)pattern).getPeriod();
        }
        throw new IllegalStateException("This task is not periodic: " + pattern.getClass().getName());
    }

    public StepBuilder withSlidingWindow(int nbEvents, String windowSize) {
        if (this.step.getCause().isEmpty()) {
            this.design.hasASlidingWindowEvent(nbEvents, windowSize).forStep(this.step).build();
        } else {
            WorkloadEvent cfr_ignored_0 = (WorkloadEvent)this.step.getCause().get(0);
        }
        return this;
    }

    public StepBuilder isSporadic(String minInterarrival, String maxInterarrival) {
        if (this.step.getCause().isEmpty()) {
            this.design.hasSporadicEvent(minInterarrival, maxInterarrival).forStep(this.step).build();
        } else {
            WorkloadEvent cfr_ignored_0 = (WorkloadEvent)this.step.getCause().get(0);
        }
        return this;
    }

    public StepBuilder isActivatedOnce() {
        if (this.step.getCause().isEmpty()) {
            this.design.hasActivationOnce().forStep(this.step).build();
        } else {
            WorkloadEvent cfr_ignored_0 = (WorkloadEvent)this.step.getCause().get(0);
        }
        return this;
    }

    public StepBuilder ofET(String value) {
        return this.ofWCET(value).ofBCET(value);
    }

    public StepBuilder ofPeriod(String value) {
        return this.isPeriodic(value);
    }

    public StepBuilder hasJitter(String jitter) {
        this.getWorkloadEvent().ofJitter(jitter);
        return this;
    }

    public StepBuilder ofOffset(String value) {
        this.getWorkloadEvent().ofOffset(value);
        return this;
    }

    public Duration getOffset() {
        return this.getWorkloadEvent().getOffset();
    }

    public StepBuilder ofDeadline(String value) {
        this.deadline = value;
        if (this.task != null && this.task instanceof TaskBuilder) {
            ((TaskBuilder)this.task).ofDeadline(value);
        }
        return this;
    }

    public Duration getDeadline() {
        return ((TaskBuilder)this.task).getDeadline();
    }

    public StepBuilder activates(StepBuilder ... successors) {
        Step origin = this.build();
        this.hasAtLeastOneOutputPin();
        for (OutputPin outputPin : origin.getOutputPin()) {
            StepBuilder[] stepBuilderArray = successors;
            int n = successors.length;
            int n2 = 0;
            while (n2 < n) {
                StepBuilder successor = stepBuilderArray[n2];
                InputPinBuilder inputPin = successor.hasAtLeastOneInputPin();
                outputPin.getSuccessors().add((Object)((InputPin)inputPin.build()));
                inputPin.withExactBound(inputPin.getSizeOfPredecessors());
                ++n2;
            }
            int nbSuccessors = outputPin.getSuccessors().size();
            outputPin.setLowerBound(nbSuccessors);
            outputPin.setUpperBound(nbSuccessors);
        }
        return this;
    }

    public InputPinBuilder hasOneInputPinNamed(String pinName) {
        this.build();
        InputPinBuilder r = null;
        for (InputPin ip : this.step.getInputPin()) {
            if (!pinName.equals(ip.getName())) continue;
            r = new InputPinBuilder(ip);
            break;
        }
        if (r == null) {
            r = new InputPinBuilder(this.step);
            r.called(pinName);
        }
        return r;
    }

    public InputPinBuilder inputPinNamed(String pinName) {
        return this.hasOneInputPinNamed(pinName);
    }

    public OutputPinBuilder hasOneOutputPinNamed(String pinName) {
        this.build();
        OutputPinBuilder r = null;
        for (OutputPin ip : this.step.getOutputPin()) {
            if (!pinName.equals(ip.getName())) continue;
            r = new OutputPinBuilder(ip);
            break;
        }
        if (r == null) {
            r = new OutputPinBuilder(this.step);
            r.called(pinName);
        }
        return r;
    }

    public OutputPinBuilder outputPinNamed(String pinName) {
        return this.hasOneOutputPinNamed(pinName);
    }

    public InputPinBuilder hasAtLeastOneInputPin() {
        this.build();
        InputPinBuilder r = this.step.getInputPin().isEmpty() ? new InputPinBuilder(this.step) : new InputPinBuilder((InputPin)this.step.getInputPin().get(0));
        return r;
    }

    public OutputPinBuilder hasAtLeastOneOutputPin() {
        this.build();
        OutputPinBuilder r = this.step.getOutputPin().isEmpty() ? new OutputPinBuilder(this.step) : new OutputPinBuilder((OutputPin)this.step.getOutputPin().get(0));
        return r;
    }

    public StepBuilder ofJitter(String value) {
        this.getWorkloadEvent().ofJitter(value);
        return this;
    }

    public StepBuilder thatResets(AlarmBuilder watchdog) {
        this.isResourceServiceExecution = true;
        this.reset = watchdog;
        return this;
    }

    public StepBuilder activatedBy(AlarmBuilder alarm) {
        this.isResourceServiceExecution = true;
        this.activatedBy = alarm;
        return this;
    }

    public StepBuilder isAtomic() {
        return this.isAtomic(true);
    }

    public StepBuilder isAtomic(boolean value) {
        this.isAtomic = value;
        return this;
    }

    public AlarmBuilder activation() {
        return null;
    }

    public void withReference(ReferenceBuilder ref) {
        if (ref == null) {
            return;
        }
        if (this.step.getCause() != null && !this.step.getCause().isEmpty()) {
            for (WorkloadEvent cause : this.step.getCause()) {
                cause.getPattern().setReference(ref.build());
            }
        }
    }

    public StepBuilder ofReference(ReferenceBuilder reference) {
        this.withReference(reference);
        return this;
    }

    public ReferenceBuilder getReference() {
        if (this.step == null) {
            this.build();
        }
        if (this.step.getCause() != null && !this.step.getCause().isEmpty()) {
            for (WorkloadEvent cause : this.step.getCause()) {
                Reference ref = cause.getPattern().getReference();
                if (ref == null) continue;
                return new ReferenceBuilder(ref);
            }
        }
        return null;
    }

    public List<WorkloadEvent> getCauses() {
        if (this.step == null) {
            this.build();
        }
        return this.step.getCause();
    }
}

