/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.HashSet;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.SchedPolicyKind;
import org.polarsys.time4sys.marte.grm.ScheduleSpecification;
import org.polarsys.time4sys.marte.grm.Scheduler;
import org.polarsys.time4sys.marte.grm.SchedulingPolicy;
import org.polarsys.time4sys.marte.grm.TableDrivenSchedule;
import org.polarsys.time4sys.marte.grm.TableEntryType;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;

public class TableDrivenSchedPolicyBuilder {
    public static final String MIF_ATTR = "mif_duration";
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private Scheduler scheduler;
    private SchedulingPolicy policy;
    private TableDrivenSchedule schedule;

    public TableDrivenSchedPolicyBuilder(Scheduler mainScheduler) {
        this.scheduler = mainScheduler;
        this.policy = this.scheduler.getPolicy();
        if (this.policy.getPolicy() != SchedPolicyKind.TIME_TABLE_DRIVEN) {
            this.policy.setPolicy(SchedPolicyKind.TIME_TABLE_DRIVEN);
        }
        if (this.policy.getSchedule() instanceof TableDrivenSchedule) {
            this.schedule = (TableDrivenSchedule)this.policy.getSchedule();
        } else {
            this.schedule = GrmFactory.eINSTANCE.createTableDrivenSchedule();
            this.policy.setSchedule((ScheduleSpecification)this.schedule);
        }
    }

    public void withMIFDuration(Duration mif) {
        Annotations.setAttr((EModelElement)this.schedule, "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", MIF_ATTR, mif.toString());
        this.updateScheduleEntries(mif);
    }

    public void updateScheduleEntries(Duration mif) {
        Duration currentOffset = NfpFactory.eINSTANCE.createDurationFromString("0ms");
        for (TableEntryType entry : this.schedule.getEntries()) {
            entry.getTimeSlot().clear();
            entry.getTimeSlot().add((Object)mif);
            entry.getOffset().clear();
            entry.getOffset().add((Object)currentOffset);
            currentOffset = currentOffset.add(mif);
        }
        this.schedule.setFrameCycleTime(currentOffset);
    }

    public Duration getMIFDuration() {
        HashSet allMIFs = new HashSet();
        for (TableEntryType entry : this.schedule.getEntries()) {
            allMIFs.addAll(entry.getTimeSlot());
        }
        if (allMIFs.size() == 1) {
            return (Duration)allMIFs.iterator().next();
        }
        if (allMIFs.isEmpty()) {
            String mifValue = Annotations.getAttr((EModelElement)this.schedule, "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", MIF_ATTR);
            return NfpFactory.eINSTANCE.createDurationFromString(mifValue);
        }
        throw new IllegalStateException("MIFs' duration are not all the same.");
    }

    public Duration getMAFDuration() {
        if (this.schedule.eIsSet((EStructuralFeature)GrmPackage.eINSTANCE.getTableDrivenSchedule_FrameCycleTime())) {
            return this.schedule.getFrameCycleTime();
        }
        Duration sum = nfpFactory.createDurationFromString("0ms");
        for (TableEntryType entry : this.schedule.getEntries()) {
            for (Duration t : entry.getTimeSlot()) {
                sum = sum.add(t);
            }
        }
        return sum;
    }

    public TableEntryType addEntry(TableEntryType entry) {
        this.schedule.getEntries().add((Object)entry);
        return entry;
    }

    public void build() {
        this.schedule.setFrameCycleTime(this.getMAFDuration());
    }

    public void called(String name) {
        this.scheduler.setName(name);
    }
}

