/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.exectime.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.TimeUnitKind;
import org.polarsys.time4sys.marte.nfp.impl.LongDurationImpl;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.SliceKind;
import org.polarsys.time4sys.trace.Trace;
import org.polarsys.time4sys.trace.util.SliceDurationStatistics;
import org.polarsys.time4sys.trace.util.SubSlicesIterator;

public class ExportCSVCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        LinkedList<File> results = new LinkedList<File>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            for (Object obj : treeSelection) {
                if (obj instanceof Slice) {
                    this.export((Slice)obj, results);
                    continue;
                }
                if (!(obj instanceof Trace)) continue;
                this.export((Trace)obj, results);
            }
        }
        return results;
    }

    protected void export(Slice obj, List<File> results) {
        ConcurrentLinkedQueue<Slice> toExplore = new ConcurrentLinkedQueue<Slice>();
        toExplore.add(obj);
        while (!toExplore.isEmpty()) {
            Slice slc = (Slice)toExplore.poll();
            toExplore.addAll((Collection<Slice>)slc.getOwnedSubSlices());
            switch (slc.getKind()) {
                case TASK: 
                case FUNCTION: {
                    try {
                        this.exportToCsv(slc, results);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        }
    }

    protected void export(Trace obj, List<File> results) {
        for (Slice slc : obj.getSlices()) {
            this.export(slc, results);
        }
    }

    private void exportToCsv(Slice slc, List<File> results) throws IOException, URISyntaxException {
        SubSlicesIterator it;
        switch (slc.getKind()) {
            case FUNCTION: {
                it = new SubSlicesIterator(slc, SliceKind.FUNCTION_INSTANCE);
                break;
            }
            case TASK: {
                it = new SubSlicesIterator(slc, SliceKind.JOB);
                break;
            }
            default: {
                return;
            }
        }
        assert (it != null);
        URI emfUri = slc.eResource().getURI();
        URI r = CommonPlugin.asLocalURI((URI)emfUri);
        String uriStr = r.toString();
        java.net.URI neturi = new java.net.URI(uriStr);
        File originFile = new File(neturi);
        File outputDir = originFile.getParentFile();
        File output = this.newOutputFile(slc, outputDir);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(output));
        while (it.hasNext()) {
            Duration duration = SliceDurationStatistics.computeExecutionTimeDuration((Slice)it.next());
            if (duration instanceof LongDurationImpl) {
                writer.write(Long.toString(((LongDurationImpl)duration).getValueInPicoSeconds()));
            } else {
                writer.write(Double.toString(duration.convertToUnit(TimeUnitKind.PS).getValue()));
            }
            writer.write(10);
        }
        writer.close();
        results.add(output);
    }

    private File newOutputFile(Slice slc, File outputDir) {
        String basename = slc.getName().replaceAll("\\s", "-");
        File output = new File(outputDir, String.valueOf(basename) + ".csv");
        int counter = 0;
        DecimalFormat formatter = new DecimalFormat("#000");
        while (output.exists()) {
            output = new File(outputDir, String.valueOf(basename) + "-" + formatter.format(counter) + ".csv");
        }
        return output;
    }
}

