/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.timinggraphics.popup.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.TimeUnitKind;
import org.polarsys.time4sys.marte.nfp.impl.LongDurationImpl;
import org.polarsys.time4sys.model.time4sys.Simulation;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.SliceKind;
import org.polarsys.time4sys.trace.Trace;
import org.polarsys.time4sys.trace.util.SliceDurationStatistics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportAsTimingGraphics
implements IObjectActionDelegate {
    protected Shell shell;
    protected Slice slice = null;
    protected Trace trace = null;
    private File output;

    public static void exportGanttXml(Slice slice, File output) throws IOException, ParserConfigurationException, TransformerException {
        new ExportAsTimingGraphics(slice).writeGanttXml(output);
    }

    public static void exportGraphicsXml(Slice slice, File output) throws IOException, ParserConfigurationException, TransformerException {
        new ExportAsTimingGraphics(slice).writeGraphicsXml(output);
    }

    public ExportAsTimingGraphics() {
        this(null);
    }

    public ExportAsTimingGraphics(Slice toBeExported) {
        this.slice = toBeExported;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.slice == null && this.trace == null) {
            return;
        }
        File folder = this.getTimingGraphicsFolder();
        Exception errGantt = this.writeGanttXml(new File(folder, "gantt.xml"));
        Exception errGraphics = this.writeGraphicsXml(new File(folder, "graphics.xml"));
        if ((errGantt == null || errGraphics == null) && MessageDialog.openQuestion((Shell)this.shell, (String)"Trace Timing Graphics(tm) exporter", (String)("Gantt chart(s) exported in " + this.output.getAbsolutePath() + ".\n" + "Would you view it?")) && this.output.exists() && this.output.isFile()) {
            Bundle plugin = Platform.getBundle((String)"org.polarsys.time4sys.trace.timinggraphics");
            if (plugin == null) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(this.output.toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.linkconet.e3.dashboard.realtimecharts.ui.views.GanttChartsView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getTimingGraphicsFolder() {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.linkconet.e3.dashboard.RealTimeCharts.ui");
        String path = preferenceStore.getString("xmlFilesLocation");
        File folder = path == null || path.trim().isEmpty() ? new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "timingGraphics") : new File(path);
        return folder;
    }

    private Exception writeGanttXml(File outputFile) {
        FileOutputStream os;
        this.output = outputFile;
        try {
            os = new FileOutputStream(this.output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return e;
        }
        OutputStreamWriter w = new OutputStreamWriter(os);
        try {
            this.exportGanttXml(w);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return e;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return e;
        }
        return null;
    }

    private Exception writeGraphicsXml(File outputFile) {
        FileOutputStream os;
        this.output = outputFile;
        try {
            os = new FileOutputStream(this.output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return e;
        }
        OutputStreamWriter w = new OutputStreamWriter(os);
        try {
            this.exportGraphicsXml(w);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return e;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return e;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.slice = null;
        if (selection.isEmpty()) {
            return;
        }
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (obj instanceof Slice) {
            this.slice = (Slice)obj;
        }
        if (obj instanceof Trace) {
            this.trace = (Trace)obj;
        }
    }

    private static Text setTextProperty(Element parent, String eltName, String value) {
        Document doc = parent.getOwnerDocument();
        Element prop = doc.createElement(eltName);
        Text textNode = doc.createTextNode(value);
        prop.appendChild(textNode);
        parent.appendChild(prop);
        return textNode;
    }

    private static void setTimePropery(Element parent, String eltName, Duration value) {
        Duration durInPS = value.convertToUnit(TimeUnitKind.PS);
        long picoseconds = durInPS instanceof LongDurationImpl ? ((LongDurationImpl)durInPS).getValueInPicoSeconds() : (long)durInPS.getValue();
        ExportAsTimingGraphics.setTextProperty(parent, eltName, Long.toString(picoseconds));
    }

    private static String percentageFormat(int value) {
        return String.format("%d.%02d", value / 100, value % 100);
    }

    private static void setPercentagePropertyTwoDigits(Element parent, String eltName, int value) {
        ExportAsTimingGraphics.setTextProperty(parent, eltName, ExportAsTimingGraphics.percentageFormat(value));
    }

    private static Element createChildElement(Element parent, String eltName) {
        Element child = parent.getOwnerDocument().createElement(eltName);
        parent.appendChild(child);
        return child;
    }

    protected void exportGraphicsXml(OutputStreamWriter w) throws IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document graphicsDoc = docBuilder.newDocument();
        Element tabsFileElt = graphicsDoc.createElement("Tabs");
        graphicsDoc.appendChild(tabsFileElt);
        Element tabSimulationLoad = ExportAsTimingGraphics.createChildElement(tabsFileElt, "Tab");
        String label = null;
        String descr = null;
        LinkedBlockingQueue<Slice> toBeDone = new LinkedBlockingQueue<Slice>();
        if (this.slice != null) {
            toBeDone.add(this.slice);
            label = this.slice.getName();
            descr = ExportAsTimingGraphics.getSimulationName((EObject)this.slice);
        }
        if (this.trace != null) {
            toBeDone.addAll((Collection<Slice>)this.trace.getSlices());
            label = "Trace";
            descr = ExportAsTimingGraphics.getSimulationName((EObject)this.trace);
        }
        if (label == null) {
            label = "";
        }
        if (descr == null) {
            descr = "";
        }
        ExportAsTimingGraphics.setTextProperty(tabSimulationLoad, "Title", "Load of " + label);
        Element dataSetsElt = ExportAsTimingGraphics.createChildElement(tabSimulationLoad, "DataSets");
        for (Slice tab : toBeDone) {
            ExportAsTimingGraphics.createLoadSelector(dataSetsElt, tab);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(graphicsDoc);
        StreamResult result = new StreamResult(w);
        transformer.transform(source, result);
    }

    private static void createLoadSelector(Element dataSetsElt, Slice root) {
        Element pieDatasetElt = ExportAsTimingGraphics.createChildElement(dataSetsElt, "PieDataset");
        ExportAsTimingGraphics.setTextProperty(pieDatasetElt, "Selector", root.getName());
        Text titleElt = ExportAsTimingGraphics.setTextProperty(pieDatasetElt, "Title", root.getName());
        Duration simDuration = root.getLatestTimestamp();
        int accumulator = 0;
        for (Slice sub : root.getSubSlices()) {
            accumulator += ExportAsTimingGraphics.addLoadItem(pieDatasetElt, sub, simDuration);
            if (sub.getKind() != SliceKind.RESOURCE && !"Package".equals(sub.getKindLabel())) continue;
            ExportAsTimingGraphics.createLoadSelector(dataSetsElt, sub);
        }
        for (Slice sub : root.getOwnedSubSlices()) {
            accumulator += ExportAsTimingGraphics.addLoadItem(pieDatasetElt, sub, simDuration);
            if (sub.getKind() != SliceKind.RESOURCE && !"Package".equals(sub.getKindLabel())) continue;
            ExportAsTimingGraphics.createLoadSelector(dataSetsElt, sub);
        }
        if (pieDatasetElt.hasChildNodes() && accumulator <= 10000) {
            if (accumulator <= 10000) {
                Element idlePieItemElt = ExportAsTimingGraphics.createChildElement(pieDatasetElt, "PieItem");
                ExportAsTimingGraphics.setTextProperty(idlePieItemElt, "Color", "FFFFFF");
                ExportAsTimingGraphics.setTextProperty(idlePieItemElt, "Key", "Idle");
                ExportAsTimingGraphics.setPercentagePropertyTwoDigits(idlePieItemElt, "Value", 10000 - accumulator);
            }
            titleElt.setTextContent(String.valueOf(titleElt.getTextContent()) + " -- " + ExportAsTimingGraphics.percentageFormat(accumulator));
        } else {
            dataSetsElt.removeChild(pieDatasetElt);
        }
    }

    private static int addLoadItem(Element pieDatasetElt, Slice sub, Duration simDuration) {
        Duration sliceDuration = SliceDurationStatistics.computeExecutionTimeDuration((Slice)sub);
        if (sliceDuration.notZero()) {
            int percentage = (int)(sliceDuration.div(simDuration, MathContext.DECIMAL32) * 10000.0);
            Element pieItemElt = ExportAsTimingGraphics.createChildElement(pieDatasetElt, "PieItem");
            ExportAsTimingGraphics.setTextProperty(pieItemElt, "Key", sub.getName());
            ExportAsTimingGraphics.setPercentagePropertyTwoDigits(pieItemElt, "Value", percentage);
            return percentage;
        }
        return 0;
    }

    protected void exportGanttXml(OutputStreamWriter w) throws IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document ganttDoc = docBuilder.newDocument();
        Element ganttFileElt = ganttDoc.createElement("GanttFile");
        ganttDoc.appendChild(ganttFileElt);
        String label = null;
        String descr = null;
        LinkedBlockingQueue<Slice> toBeDone = new LinkedBlockingQueue<Slice>();
        if (this.slice != null) {
            toBeDone.add(this.slice);
            label = this.slice.getName();
            descr = ExportAsTimingGraphics.getSimulationName((EObject)this.slice);
        }
        if (this.trace != null) {
            toBeDone.addAll((Collection<Slice>)this.trace.getSlices());
            label = "Trace";
            descr = ExportAsTimingGraphics.getSimulationName((EObject)this.trace);
        }
        if (label == null) {
            label = "";
        }
        if (descr == null) {
            descr = "";
        }
        ExportAsTimingGraphics.setTextProperty(ganttFileElt, "Date", new Date().toString());
        ExportAsTimingGraphics.setTextProperty(ganttFileElt, "Description", descr);
        ExportAsTimingGraphics.setTextProperty(ganttFileElt, "Name", label);
        ExportAsTimingGraphics.setTextProperty(ganttFileElt, "Uuid", UUID.randomUUID().toString());
        Element tabsElt = ExportAsTimingGraphics.createChildElement(ganttFileElt, "Tabs");
        Element tabElt = ExportAsTimingGraphics.createChildElement(tabsElt, "Tab");
        ExportAsTimingGraphics.setTextProperty(tabElt, "Name", "Gantts");
        Element configElt = ExportAsTimingGraphics.createChildElement(tabElt, "Config");
        ExportAsTimingGraphics.setTextProperty(configElt, "Unit", "ms");
        Element ganttsElt = ExportAsTimingGraphics.createChildElement(tabElt, "Gantts");
        for (Slice tab : toBeDone) {
            ExportAsTimingGraphics.createGanttSelector(ganttsElt, tab);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(ganttDoc);
        StreamResult result = new StreamResult(w);
        transformer.transform(source, result);
    }

    private static void createGanttSelector(Element ganttsElt, Slice root) {
        Element ganttElt = ExportAsTimingGraphics.createChildElement(ganttsElt, "Gantt");
        ExportAsTimingGraphics.setTextProperty(ganttElt, "Selector", root.getName());
        ExportAsTimingGraphics.setTextProperty(ganttElt, "Title", root.getName());
        ExportAsTimingGraphics.setTextProperty(ganttElt, "Date", "01/01/2017 10:00:00");
        ExportAsTimingGraphics.setTextProperty(ganttElt, "Description", root.getName());
        ExportAsTimingGraphics.setTimePropery(ganttElt, "Length", root.getLatestTimestamp());
        Element ganttLinesElt = ExportAsTimingGraphics.createChildElement(ganttElt, "GanttLines");
        for (Slice sub : root.getSubSlices()) {
            ExportAsTimingGraphics.addGanttLine(ganttLinesElt, sub.getName(), sub, "activation");
            if (sub.getKind() != SliceKind.RESOURCE && !"Package".equals(sub.getKindLabel())) continue;
            ExportAsTimingGraphics.createGanttSelector(ganttsElt, sub);
        }
        for (Slice sub : root.getOwnedSubSlices()) {
            ExportAsTimingGraphics.addGanttLine(ganttLinesElt, sub.getName(), sub, "activation");
            if (sub.getKind() != SliceKind.RESOURCE && !"Package".equals(sub.getKindLabel())) continue;
            ExportAsTimingGraphics.createGanttSelector(ganttsElt, sub);
        }
        if (!ganttLinesElt.hasChildNodes()) {
            ganttsElt.removeChild(ganttElt);
        }
    }

    private static void addGanttLine(Element ganttGanttLinesElt, String name, Slice sub, String label) {
        Element ganttLineElt = ExportAsTimingGraphics.createChildElement(ganttGanttLinesElt, "GanttLine");
        ExportAsTimingGraphics.setTextProperty(ganttLineElt, "Name", sub.getName());
        ExportAsTimingGraphics.setTextProperty(ganttLineElt, "TextLine1", sub.getKindLabel());
        ExportAsTimingGraphics.setTextProperty(ganttLineElt, "TextLine2", " ");
        ExportAsTimingGraphics.setTextProperty(ganttLineElt, "Description", sub.getName());
        Element ganttElementsElt = ExportAsTimingGraphics.createChildElement(ganttLineElt, "GanttElements");
        List<Slice> slices = ExportAsTimingGraphics.getSlicesOfSlices(sub);
        for (Slice job : ExportAsTimingGraphics.filterSliceKind(slices, SliceKind.JOB)) {
            ExportAsTimingGraphics.createGanttElement(ganttElementsElt, job);
        }
    }

    private static List<Slice> filterSliceKind(List<Slice> slices, SliceKind job) {
        ArrayList<Slice> filteredSlices = new ArrayList<Slice>();
        for (Slice slice : slices) {
            if (!slice.getKind().equals((Object)job)) continue;
            filteredSlices.add(slice);
        }
        return filteredSlices;
    }

    private static List<Slice> getSlicesOfSlices(Slice sub) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        return ExportAsTimingGraphics.getSlicesOfSlices(slices, sub);
    }

    private static List<Slice> getSlicesOfSlices(List<Slice> accumulator, Slice sub) {
        if (sub.getOwnedSubSlices().size() > 0) {
            accumulator.addAll((Collection<Slice>)sub.getOwnedSubSlices());
            for (Slice owned : sub.getOwnedSubSlices()) {
                ExportAsTimingGraphics.getSlicesOfSlices(accumulator, owned);
            }
        }
        if (sub.getSubSlices().size() > 0) {
            accumulator.addAll((Collection<Slice>)sub.getOwnedSubSlices());
            for (Slice owned : sub.getSubSlices()) {
                ExportAsTimingGraphics.getSlicesOfSlices(accumulator, owned);
            }
        }
        return accumulator;
    }

    private static void createGanttElement(Element parent, Slice job) {
        Element ganttElementElt = ExportAsTimingGraphics.createChildElement(parent, "GanttElement");
        ExportAsTimingGraphics.setTextProperty(ganttElementElt, "Name", job.getName());
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        ExportAsTimingGraphics.setTextProperty(ganttElementElt, "Id", nf.format(((Event)job.getAggregatedEvents().get(0)).getTimestamp().convertToUnit(TimeUnitKind.MS).getValue()));
        Element statusesElt = ExportAsTimingGraphics.createChildElement(ganttElementElt, "Statuses");
        Element elementEventsElt = null;
        for (Event evt : job.getAggregatedEvents()) {
            if (!(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent schedEvt = (SchedulingEvent)evt;
            switch (schedEvt.getKind()) {
                case ACTIVATED: 
                case SUSPENDED: 
                case BLOCKED: 
                case TERMINATED: {
                    ExportAsTimingGraphics.createStatus(statusesElt, schedEvt);
                    break;
                }
                case RUNNING: {
                    ExportAsTimingGraphics.createStatus(statusesElt, schedEvt, "STARTED");
                    break;
                }
                case DEADLINE: {
                    if (elementEventsElt == null) {
                        elementEventsElt = ExportAsTimingGraphics.createChildElement(ganttElementElt, "ElementEvents");
                    }
                    ExportAsTimingGraphics.createEvent(elementEventsElt, schedEvt, null);
                }
            }
        }
    }

    private static void createStatus(Element statusesElt, SchedulingEvent evt) {
        ExportAsTimingGraphics.createStatus(statusesElt, evt, null);
    }

    private static void createStatus(Element parent, SchedulingEvent evt, String type) {
        ExportAsTimingGraphics.createTypedTimedElt(parent, "Status", evt, type);
    }

    private static void createEvent(Element parent, SchedulingEvent evt, String type) {
        Element elementEventElt = ExportAsTimingGraphics.createTypedTimedElt(parent, "ElementEvent", evt, null);
        ExportAsTimingGraphics.setTextProperty(elementEventElt, "Label", "");
    }

    private static Element createTypedTimedElt(Element parent, String eltName, SchedulingEvent evt, String type) {
        if (type == null) {
            type = evt.getKind().getName().toUpperCase();
        }
        Element childElt = ExportAsTimingGraphics.createChildElement(parent, eltName);
        ExportAsTimingGraphics.setTextProperty(childElt, "Type", type);
        ExportAsTimingGraphics.setTimePropery(childElt, "Instant", evt.getTimestamp());
        return childElt;
    }

    private static String getSimulationName(EObject slice) {
        Simulation simu = ExportAsTimingGraphics.getSimulation(slice);
        if (simu == null) {
            return "";
        }
        String name = simu.getName();
        if (name == null) {
            return "";
        }
        return name;
    }

    private static Simulation getSimulation(EObject slice) {
        if (slice == null) {
            return null;
        }
        EObject current = slice.eContainer();
        while (current != null) {
            if (current instanceof Simulation) {
                return (Simulation)current;
            }
            current = current.eContainer();
        }
        return null;
    }
}

