/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class JavaScriptCodeFactory
extends AbstractCodeFactory {
    private static final List<String> RESERVED_KEYWORDS = Arrays.asList("abstract", "arguments", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield");

    public static boolean isSaveName(String identifier) {
        return Pattern.matches("[a-zA-Z_$][a-zA-Z0-9_$]*", identifier) && !RESERVED_KEYWORDS.contains(identifier);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append("new Packages.").append(clazz.getName()).append('(');
        if (parameters != null) {
            code.append(Arrays.asList(parameters).stream().collect(Collectors.joining(", ")));
        }
        code.append(')');
        return code.toString();
    }

    protected String getNullString() {
        return "null";
    }

    public String getSaveVariableName(String variableName) {
        if (JavaScriptCodeFactory.isSaveName(variableName)) {
            return variableName;
        }
        StringBuilder buffer = new StringBuilder(variableName.replaceAll("[^a-zA-Z0-9_$]", "_"));
        if (buffer.length() > 0) {
            char start = buffer.charAt(0);
            if ((start < 'A' || start > 'Z' && start < 'a' || start > 'z') && start != '_') {
                buffer.insert(0, '_');
            }
        } else {
            buffer.append('_');
            int index = 0;
            while (index < new Random().nextInt(20)) {
                buffer.append(97 + new Random().nextInt(26));
                ++index;
            }
        }
        if (RESERVED_KEYWORDS.contains(buffer.toString())) {
            return "_" + buffer.toString();
        }
        return buffer.toString();
    }

    private StringBuilder verifyParameters(Method method, List<ICodeFactory.Parameter> parameters, String indent) {
        StringBuilder data = new StringBuilder();
        if (!parameters.isEmpty()) {
            ICodeFactory.Parameter parameter = parameters.get(parameters.size() - 1);
            data.append(indent).append("if (typeof " + parameter.getName() + " === \"undefined\") {").append(StringTools.LINE_DELIMITER);
            if (parameter.isOptional()) {
                data.append(indent).append("\t" + parameter.getName() + " = " + this.getDefaultValue(parameter) + ';').append(StringTools.LINE_DELIMITER);
            } else {
                data.append(indent).append("\tthrow 'Parameter <" + parameter.getName() + "> from " + method.getName() + "() is not optional';").append(StringTools.LINE_DELIMITER);
            }
            data.append((CharSequence)this.verifyParameters(method, parameters.subList(0, parameters.size() - 1), String.valueOf(indent) + "\t"));
            data.append(indent).append('}').append(StringTools.LINE_DELIMITER);
        }
        return data;
    }

    public String createCommentedString(String comment, boolean addBlockComment) {
        if (addBlockComment) {
            StringBuilder builder = new StringBuilder();
            builder.append("/**").append(StringTools.LINE_DELIMITER);
            String[] stringArray = comment.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                builder.append(" * ").append(line).append(StringTools.LINE_DELIMITER);
                ++n2;
            }
            builder.append(" */").append(StringTools.LINE_DELIMITER);
            return builder.toString();
        }
        return super.createCommentedString(comment, addBlockComment);
    }

    public String createWrapper(IEnvironment environment, Object instance, String identifier, boolean customNamespace, IScriptEngine engine) {
        if (customNamespace) {
            return this.createObjectWrapper(environment, instance, identifier);
        }
        return super.createWrapper(environment, instance, identifier, customNamespace, engine);
    }

    private String createObjectWrapper(IEnvironment environment, Object instance, String identifier) {
        StringBuilder scriptCode = new StringBuilder();
        scriptCode.append("__EASE_temporary_wrapper_object = {").append(StringTools.LINE_DELIMITER);
        scriptCode.append("\tjavaInstance: ").append(identifier).append(',').append(StringTools.LINE_DELIMITER);
        scriptCode.append(StringTools.LINE_DELIMITER).append("\t// field definitions").append(StringTools.LINE_DELIMITER);
        for (Field field : ModuleHelper.getFields(instance.getClass())) {
            if (!this.isSupportedByLanguage(field)) continue;
            scriptCode.append('\t').append(field.getName()).append(": ").append(identifier).append('.').append(field.getName()).append(',').append(StringTools.LINE_DELIMITER);
        }
        scriptCode.append(StringTools.LINE_DELIMITER).append("\t// method definitions").append(StringTools.LINE_DELIMITER);
        for (Method method : ModuleHelper.getMethods(instance.getClass())) {
            if (!this.isSupportedByLanguage(method)) continue;
            List parameters = ModuleHelper.getParameters((Method)method);
            String body = "\t\t" + this.buildMethodBody(environment, parameters, method, identifier).replaceAll("\n", "\n\t\t");
            scriptCode.append('\t').append(method.getName()).append(": function(");
            scriptCode.append(this.buildParameterList(parameters)).append(") {").append(StringTools.LINE_DELIMITER);
            scriptCode.append(body).append(StringTools.LINE_DELIMITER);
            scriptCode.append("\t},").append(StringTools.LINE_DELIMITER).append(StringTools.LINE_DELIMITER);
            for (String alias : JavaScriptCodeFactory.getMethodAliases((Method)method)) {
                if (!JavaScriptCodeFactory.isSaveName(alias)) {
                    Logger.error((String)"org.eclipse.ease.lang.javascript", (String)("The method name \"" + alias + "\" from the module \"" + identifier + "\" can not be wrapped because it's name is reserved"));
                    continue;
                }
                if (alias.isEmpty()) continue;
                scriptCode.append('\t').append(alias).append(": function(");
                scriptCode.append(this.buildParameterList(parameters)).append(") {").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t\t// method alias").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t\treturn this.").append(method.getName()).append('(').append(this.buildParameterList(parameters)).append(");").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t},").append(StringTools.LINE_DELIMITER).append(StringTools.LINE_DELIMITER);
            }
        }
        scriptCode.append("};").append(StringTools.LINE_DELIMITER);
        return scriptCode.toString();
    }

    protected String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder javaScriptCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        String parameterList = this.buildParameterList(parameters);
        String body = "\t" + this.buildMethodBody(environment, parameters, method, moduleVariable).replaceAll("\n", "\n\t");
        for (String name : JavaScriptCodeFactory.getMethodNames((Method)method)) {
            if (!JavaScriptCodeFactory.isSaveName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.javascript", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            javaScriptCode.append("function ").append(name).append('(').append(parameterList).append(") {").append(StringTools.LINE_DELIMITER);
            javaScriptCode.append(body).append(StringTools.LINE_DELIMITER);
            javaScriptCode.append('}').append(StringTools.LINE_DELIMITER);
        }
        return javaScriptCode.toString();
    }

    protected String createFieldWrapper(IEnvironment environment, String identifier, Field field) {
        StringBuilder javaScriptCode = new StringBuilder();
        javaScriptCode.append(String.format("var %s = %s.%s;", field.getName(), identifier, field.getName()));
        javaScriptCode.append(StringTools.LINE_DELIMITER);
        return javaScriptCode.toString();
    }

    private String buildMethodBody(IEnvironment environment, List<ICodeFactory.Parameter> parameters, Method method, String classIdentifier) {
        StringBuilder body = new StringBuilder();
        body.append("// verify mandatory and optional parameters").append(StringTools.LINE_DELIMITER);
        body.append((CharSequence)this.verifyParameters(method, parameters, "")).append(StringTools.LINE_DELIMITER);
        if (ModuleHelper.isDeprecated((AccessibleObject)method)) {
            body.append("printError('" + method.getName() + "() is deprecated. Consider updating your code.', true);").append(StringTools.LINE_DELIMITER);
        }
        String methodId = environment.registerMethod(method);
        body.append("if (!").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".hasMethodCallback(\"").append(methodId).append("\")) {").append(StringTools.LINE_DELIMITER);
        body.append("\t// delegate call to java layer").append(StringTools.LINE_DELIMITER);
        body.append("\treturn ").append(classIdentifier).append('.').append(method.getName()).append('(');
        body.append(this.buildParameterList(parameters));
        body.append(");").append(StringTools.LINE_DELIMITER).append(StringTools.LINE_DELIMITER);
        body.append("} else {").append(StringTools.LINE_DELIMITER);
        body.append("\t").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback('").append(methodId).append("'").append(parameters.isEmpty() ? "" : ", ").append(this.buildParameterList(parameters)).append(");").append(StringTools.LINE_DELIMITER);
        body.append(StringTools.LINE_DELIMITER);
        body.append("\t// delegate call to java layer").append(StringTools.LINE_DELIMITER);
        body.append("\tvar ").append("__result").append(" = ").append(classIdentifier).append('.').append(method.getName()).append('(');
        body.append(this.buildParameterList(parameters));
        body.append(");").append(StringTools.LINE_DELIMITER);
        body.append(StringTools.LINE_DELIMITER);
        body.append("\t").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".postMethodCallback('").append(methodId).append("', ").append("__result").append(");").append(StringTools.LINE_DELIMITER);
        body.append(StringTools.LINE_DELIMITER);
        body.append("\treturn __result;").append(StringTools.LINE_DELIMITER);
        body.append(StringTools.LINE_DELIMITER);
        body.append("}").append(StringTools.LINE_DELIMITER);
        return body.toString();
    }

    protected Object getLanguageIdentifier() {
        return "JavaScript";
    }

    protected String toSafeName(String name) {
        while (RESERVED_KEYWORDS.contains(name)) {
            name = String.valueOf(name) + "_";
        }
        return name;
    }
}

