/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.client.wrapper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.tracecompass.incubator.internal.filters.core.Activator;
import org.eclipse.tracecompass.incubator.internal.filters.core.client.LanguageFilterClient;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.FilterLspConfiguration;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.LspObserver;

public class LanguageFilterClientWrapper {
    private LanguageFilterClient fLanguageClient = null;
    private Socket fSocket = null;

    public LanguageFilterClientWrapper(final String hostname, final Integer port, final @NonNull LspObserver observer, final String documentUri) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (LanguageFilterClientWrapper.this.fSocket == null) {
                    try {
                        try {
                            LanguageFilterClientWrapper.this.fSocket = new Socket(hostname, (int)port);
                        }
                        catch (Exception exception) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e1) {
                                Activator.getInstance().logError(e1.getMessage());
                            }
                            try {
                                if (LanguageFilterClientWrapper.this.fSocket == null) continue;
                                LanguageFilterClientWrapper.this.initialize(LanguageFilterClientWrapper.this.fSocket.getInputStream(), LanguageFilterClientWrapper.this.fSocket.getOutputStream(), observer, documentUri);
                            }
                            catch (IOException e) {
                                Activator.getInstance().logError(e.getMessage());
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (LanguageFilterClientWrapper.this.fSocket != null) {
                                LanguageFilterClientWrapper.this.initialize(LanguageFilterClientWrapper.this.fSocket.getInputStream(), LanguageFilterClientWrapper.this.fSocket.getOutputStream(), observer, documentUri);
                            }
                        }
                        catch (IOException e) {
                            Activator.getInstance().logError(e.getMessage());
                        }
                        throw throwable;
                    }
                    try {
                        if (LanguageFilterClientWrapper.this.fSocket == null) continue;
                        LanguageFilterClientWrapper.this.initialize(LanguageFilterClientWrapper.this.fSocket.getInputStream(), LanguageFilterClientWrapper.this.fSocket.getOutputStream(), observer, documentUri);
                    }
                    catch (IOException e) {
                        Activator.getInstance().logError(e.getMessage());
                    }
                }
            }
        }).start();
    }

    public LanguageFilterClientWrapper(@NonNull LspObserver observer, String documentUri) {
        this("127.0.0.1", FilterLspConfiguration.PORT, observer, documentUri);
    }

    @VisibleForTesting
    public LanguageFilterClientWrapper(InputStream in, OutputStream out, @NonNull LspObserver observer) {
        this.initialize(in, out, observer, null);
    }

    private void initialize(InputStream in, OutputStream out, @NonNull LspObserver observer, String documentUri) {
        this.fLanguageClient = new LanguageFilterClient();
        Launcher launcher = LSPLauncher.createClientLauncher((LanguageClient)this.fLanguageClient, (InputStream)in, (OutputStream)out);
        this.fLanguageClient.setServer((LanguageServer)launcher.getRemoteProxy());
        this.fLanguageClient.register(observer);
        launcher.startListening();
        if (documentUri != null) {
            this.fLanguageClient.tellDidOpen(documentUri);
        }
    }

    public LanguageFilterClient getLanguageClient() {
        return this.fLanguageClient;
    }

    public void notify(String Uri, String input, int cursorPos) {
        if (this.fLanguageClient == null) {
            return;
        }
        this.fLanguageClient.tellDidChange(Uri, input, cursorPos);
    }

    public void dispose() {
        try {
            try {
                if (this.fLanguageClient != null) {
                    this.fLanguageClient.shutdown();
                }
            }
            catch (Exception e) {
                Activator.getInstance().logError(e.getMessage());
                try {
                    if (this.fSocket != null) {
                        this.fSocket.close();
                    }
                }
                catch (Exception e2) {
                    Activator.getInstance().logError(e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (this.fSocket != null) {
                    this.fSocket.close();
                }
            }
            catch (Exception e) {
                Activator.getInstance().logError(e.getMessage());
            }
        }
    }
}

